﻿<?xml version = "1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- ELP_ELM_REPORT_TITLE_STRING: ^0400^ -->
<!-- Copyright @2002 Motorola Inc.  All rights reserved -->
<!-- The mode specifies which block to process -->
<!-- Any 4 digit numbers surrounded by Carats are to be replaced by the value in the report specific translation file -->

<!-- Modification History -->
<!-- Author   RAD Number Date     Description -->
<!-- M. Sheng RADsw07291 10/21/02 Removed External Alarm Configuration -->
<!-- M. Sheng RADsw07289 10/21/02 Monitor Type is a Portable Only Feature  -->
<picture_list>
   <list type = "common">
      <pic>scan1.jpg</pic>
      <pic>scan2.jpg</pic>
      <pic>scan0.jpg</pic>
   </list>
</picture_list>

<!-- CDDts09157-Sean --> 
<!-- ProductLine --> 
   <xsl:variable name = "m_ProductLine">
      	<xsl:choose>
	       	<xsl:when test ="contains(ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'Japan')">
	       		ELT_Ninja
	       	</xsl:when>
	       	<xsl:otherwise>
	       	     <xsl:choose>
	       		<xsl:when test ="contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65QDJ9AJ2') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65RDJ9AJ2') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65JDJ9AJ2') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65KDJ9AJ2') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65QDK9AJ2') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65RDK9AJ2')" >
	       			ELT_MOR
	       		</xsl:when>
	       		<xsl:otherwise>
	       			ELT_Conv
	       		</xsl:otherwise>
	       	     </xsl:choose>
	       	</xsl:otherwise>
	</xsl:choose>
   </xsl:variable>


   <xsl:template match = "/">
      <xsl:text disable-output-escaping = "yes"> 
	&lt;html dir=^0034^> &lt;meta http-equiv="Content-Type" CONTENT = "text/html; charset=utf-8"> 
      </xsl:text>
         <head>
            <title>
            ^0014^ 
            <xsl:value-of select = "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_SERIALNUM" />
            ^0013^
            <xsl:value-of select = "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM" />
            </title>
            <xsl:text disable-output-escaping = "yes">
               &lt;style>
                  &lt;!--
                  h1 {text-align: center; font-size:26; color: blue}
                  h3 {text-align: left; font-size: 18;}
                  th {text-align: left; font-size: 12; font-weight: bold;color: blue}
                  td.repeat {vertical-align: top; font-size: 10; width: 125px}
                  td.bottom {vertical-align: bottom; font-size: 10}
                  td {vertical-align: top; font-size: 10}
                  td.em {text-align: left; font-size: 10; font-weight: bold; width: 155px}
                  td.em1 {text-align: left; font-size: 12; font-weight: bold; color: blue}
                  td.em2 {text-align: left; font-size: 14; font-weight: bold; color: blue}
                  td.left {vertical-align: top; font-size: 10; text-align: left; font-weight: bold; width: 200px;}
                  td.left2 {vertical-align: top; font-size: 10; text-align: left; font-weight: bold; }
                  table.nonrepeat { width: 400; border: 1px;}
                  h3.breakBefore {page-break-before: always}
                  h3.breakAfter {page-break-after: always}
                  h3.breakBoth {page-break-before: always; page-break-after: always}
                  -->
               &lt;/style>
            </xsl:text>
         </head>
         <body>

         
         <!-- Radio Information -->
            <h1> ^0400^ </h1>
            <h3> ^0401^ </h3>
            <table class = "nonrepeat"> 	            
	       <xsl:if test ="contains(ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'Japan')">
		      <tr>
		         <td class = "left">
		            <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE/@DISPLAY_NAME"/>
		         </td>
		         <td>
		            <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE" /> 
		         </td> 
		      </tr>
	       </xsl:if>
               <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA" mode = "RI_BLOCK" />  
               <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA" mode = "TI_BLOCK" />
            </table>

<!-- General Settings -->
            <h3>^0413^</h3>
            <table class = "nonrepeat">
               <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA" mode = "RC_BLOCK" />
            </table>

<!-- Accessories -->
            <h3> ^0406^ </h3>
            <table class = "nonrepeat">
               <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Portable'">
                  <tr>
                     <td class = "left">
                        <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_HEADSETEN/@DISPLAY_NAME" />:
                     </td>
                     <td>
                        <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_HEADSETEN" />
                     </td>
                  </tr>
               </xsl:if>
               <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Mobile'">
                  <tr>
                     <td colspan = "3" class = "left2">
                        <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_ACCMICGAIN/@DISPLAY_NAME" />:
                     </td>
                     <td colspan = "2"> 
                        <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_ACCMICGAIN" />
                     </td>
                  </tr>
               </xsl:if>
               <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Portable'">
                  <tr>
                     <td class = "left">
                        <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_VOXMICGAIN/@DISPLAY_NAME" />:
                     </td>
                     <td> 
                        <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_VOXMICGAIN" />
                     </td>
                  </tr>
               </xsl:if>
               <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE != 'Portable'">
                  <tr>
                     <td colspan = "3" class = "left2">
                        <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_DATAPTTAUDSRC/@DISPLAY_NAME" />:
                     </td>
                     <td colspan = "2">
                        <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_DATAPTTAUDSRC" />
                     </td>
                  </tr>
                  <tr>
                     <td colspan = "3" class = "left2">
                        <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_EXTPTTAUDSRC/@DISPLAY_NAME" />:
                     </td>
                     <td colspan = "2">
                        <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_EXTPTTAUDSRC" />
                     </td>
                  </tr> 
                  <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW" mode = "AC_BLOCK" />   
               </xsl:if>
            </table>
            
<!-- Buttons -->            
            <h3 class = "breakBefore">^0414^</h3>
            <table class = "nonrepeat">
               <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA" mode = "CBP_BLOCK" />
            </table>

<!-- Option Board -->
            <xsl:if test = "(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') or
                            contains (/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PNK')) and 
                            not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50JDF9AA5AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50JDH9AA6AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KDF9AA5AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KDH9AA6AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50QDF9AA5AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50QDH9AA6AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50RDF9AA5AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50RDH9AA6AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50SDF9AA5AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50SDH9AA6AN'))">
               <h3>^0418^</h3>
               <xsl:apply-templates select = "ELP_ELM_CODEPLUG" mode = "option_board" />
            </xsl:if>


<!-- Programmable Menu -->
            <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
               <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/MENU_BLOCK" />
            </xsl:if>
            
<!-- Channel position -->
            <h3 class = "breakBefore">^0807^</h3>
            <table>
                <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/PA_BLOCK/X_PA_LIST/X_CHANNAL_ALIAS" />
            </table>

<!-- Signaling Configuration -->
            <xsl:if test="not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'G2W'))">
	     		      <h3 class = "breakBefore">^0415^</h3>
            		<table class = "nonrepeat">
               		<xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA" mode = "SC_BLOCK" />
            		</table>
	         </xsl:if>
	         
	<xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'Japan')">
		<h3> ^0900^ </h3>	
		   <table class = "nonrepeat">	
                     <tr>
                        <td class = "left">     
		            <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_ATISNO/@DISPLAY_NAME"/>                      
                        </td>
                        <td>
		            <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_ATISNO" /> 
                        </td>
                     </tr>
                   </table>
                     <table>
                        <xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRW/ATIS_BLOCK" />
                     </table>
	</xsl:if>

<!-- MDC / Emergency Features -->
            <xsl:if test="not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'G2W'))">
              <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani'))">
               <xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_MDCCNV = '1'">
	            <h3> ^0405^ </h3>
	       <!-- Added by Alice Wan, CCB410 -->
               <xsl:if test = "($MdcEmerEnable = 'true') or 
			       contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MARLIN') or
                               contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
               <!-- Added by Alice Wan, CCB410 -->
                  <table class = "nonrepeat">
                     <tr>
                        <td class = "left">
                           ^0428^
                        </td>
                        <td>
                           <xsl:choose>
						            <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/X_SC_EMTYPE, 'B')">
							            <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE" />
						            </xsl:when>
							         <xsl:otherwise>
							            ^0000^
							         </xsl:otherwise>
							      </xsl:choose>
                        </td>
                     </tr>                  
                     <tr>
                        <td class = "left">
                           ^0429^
                        </td>
                        <td>
                           <xsl:variable name = "index">
                              <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMREVPERSINDEX" />
                           </xsl:variable>
                           <xsl:choose>
				<xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
				     ^0316^
				</xsl:when>
				<xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMREVPERSINDEX = '255'">
				     Selected
				</xsl:when>
				<xsl:otherwise>
				    <xsl:choose>
                                        <xsl:when test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR != 1">
                                            <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index +1)]/ALIAS" />
                                        </xsl:when>  
				        <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMREVPERSTYPE = 'LS Trunking'">
				            LTR <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA[position() = ($index+1)]/ALIAS"/>
				        </xsl:when>
				        <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMREVPERSTYPE = 'Conventional'">
				            CNV <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index +1)]/ALIAS" />
				        </xsl:when>				    
				    </xsl:choose>
				</xsl:otherwise>
			   </xsl:choose>
                        </td>
                     </tr>
                     <tr>
                        <td class = "left">
                           ^0430^
                        </td>
                        <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMREVPERSINDEX = '255'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMSTREVEN" />
							  </xsl:otherwise>
						   </xsl:choose>
                        </td>
                     </tr>
                     <!-- Added by Alice Wan, CCB410 -->
                     <xsl:if test = "($MdcEmerEnable = 'true') or
                                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
                     <!-- Added by Alice Wan, CCB410 -->
                       <!-- Added by Alice Wan, CCB410 2010-6-7 -->
		       <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE != 'Portable'">
                        <tr>
                           <td class = "left">
                              ^0431^
                           </td>
                           <td>
						   <xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/EMDC_BLOCK/ENTRY_DATA/EMDC_EMMODE" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
                        </xsl:if>
			<!-- Added by Alice Wan, CCB410 2010-6-7 -->
                        <tr>
                           <td class = "left">
                              ^0432^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMLEDEN" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
                        <tr>
                           <td class = "left">
                              ^0433^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMALERTEN" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
                        <tr>
                           <td class = "left">
                              ^0434^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMACKALERTEN" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
                        <tr>
                           <td class = "left">
                              ^0435^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMSIDETONEEN" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
		<!-- Added by Alice Wan, CCB410 2010-7-20 -->
		   <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE != 'Portable'">
                        <tr>
                           <td class = "left">
                              ^0436^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMLONGPRESSDUR" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
		    </xsl:if>
		<!-- Added by Alice Wan, CCB410 2010-7-20 -->
                        <tr>
                           <td class = "left">
                              ^0437^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_IMPEMALARMRET" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
                        <tr>
                           <td class = "left">
                              ^0438^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_POLEMALARMRET" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
                        <tr>
                           <td class = "left">
                              ^0439^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_OPENMICDUR" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
                        <tr>
                           <td class = "left">
                              ^0440^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_OPENMICDUR = '0'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/EMDC_BLOCK/ENTRY_DATA/EMDC_EMTXCYCLES" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
                        <tr>
                           <td class = "left">
                              ^0441^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
							  <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_OPENMICDUR = '0'">
							     ^0316^
							  </xsl:when>
							  <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/EMDC_BLOCK/ENTRY_DATA/EMDC_EMTXCYCLES = '1'">
							     ^0316^
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/EMDC_BLOCK/ENTRY_DATA/EMDC_EMTXCYCLESDELAY" />
							  </xsl:otherwise>
						   </xsl:choose>
                           </td>
                        </tr>
                      <!-- Added by Alice Wan, CCB410 2010-6-7 -->
		      <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE != 'Portable'"> 
                        <tr>
                           <td class = "left">
                              ^0442^
                           </td>
                           <td>
							<xsl:choose>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/SC_BLOCK/ENTRY_DATA/SC_EMTYPE = '^0000^'">
							     ^0316^
							  </xsl:when>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/EMDC_BLOCK/ENTRY_DATA/EMDC_EMMODE != '^0626^'">
							     ^0316^
							  </xsl:when>
						      <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/EMDC_BLOCK/ENTRY_DATA/EMDC_EMPTTIDEN = '0'">
							  </xsl:when>							  
							  <xsl:otherwise>
								<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/EMDC_BLOCK/ENTRY_DATA/EMDC_EMPTTID" />
							  </xsl:otherwise>
						   </xsl:choose>
                              
                           </td>
                        </tr>
                      </xsl:if>
		      <!-- Added by Alice Wan, CCB410 2010-6-7 -->
		      
                     </xsl:if>                                   
                  </table>
               </xsl:if>  <!-- End if Marlin/M+ -->
<!-- MDC Systems -->
                  <br /><table>
	                   <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/MDC_BLOCK" />
	               </table>
                </xsl:if>  <!-- End if MDC Block enabled -->
<!-- Quik-Call II Systems -->
                  <h3> ^0404^ </h3>
	                  <table>
	                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/QC_BLOCK" />
	                  </table>
<!-- DTMF Systems -->                  
<xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_DTMF = '1'">                  
<h3> ^0446^ </h3>
                     <table>
                        <xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRW/DTMF_BLOCK" />
                     </table>
</xsl:if>
</xsl:if> <!-- End if not Kani -->
	<xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_SDT, '1')">
		<h3> ^0909^ </h3>
                     <table>
                        <xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRW/SDT_BLOCK " />
                     </table>
	</xsl:if>

     </xsl:if>  <!-- End if not Guppy 2W -->			
			 
            <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani')) and
            		   (contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS'))">
<!-- Phone List -->
               <h3 class = "breakBefore">^0426^</h3>
               <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/PN_BLOCK" />
<!-- Phone Systems -->               
               <h3>^0417^</h3>
               <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/PS_BLOCK" />

			</xsl:if>

			 <!-- Added by Yuek for CCB410 -->
			 <xsl:variable name = "MDFToneTaggingFlag">
				 <xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_TONGTAGGING"/>
			 </xsl:variable>

			 <xsl:variable name ="ToneTaggingEnable">
				 <xsl:value-of select="($cpver >= '09.00') and contains($m_ProductLine, 'ELT_Conv') and ($MDFToneTaggingFlag = '1')"/>
			 </xsl:variable>

			 <xsl:variable name = "DisplayType">
				 <xsl:value-of select="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_DISPTYPE"/>
			 </xsl:variable>

			 <xsl:variable name ="NonDisplayToneTagging">
				 <xsl:value-of select="($DisplayType ='None') and ($ToneTaggingEnable = 'true')"/>
			 </xsl:variable>
			 <!-- End added -->

			 <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani')) and
            		   (contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') or
					        ($NonDisplayToneTagging = 'true'))">
				 <!-- Call -->
				 <h3 class = "breakBefore">^0419^</h3>
				 <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CALL_BLOCK" />
				 <!-- CDDts06746-Sean -->
				 <!-- MDC Call -->

				 <xsl:variable name = "cpver">
					 <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
				 </xsl:variable>

				 <xsl:if test = "($cpver >= '03.01') and
               			contains($m_ProductLine, 'ELT_Conv') and
                               contains(/ELP_ELM_CODEPLUG/RRW/TC_BLOCK/MDCC_BLOCK, '1') ">
					 <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/MDCC_BLOCK" />
				 </xsl:if>
			 </xsl:if>

			 <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani')) and
            		   (contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS'))">				 
				 <!-- QC Call -->
				 <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/QCC_BLOCK" />
				 <!-- DTMF Call -->
				 <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/DTMFC_BLOCK" />
			 </xsl:if>

<!-- Conventional Personality -->
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK" /> 
            
<!-- LTR Sites  -->
            <xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR = 1">
                <h3 class = "breakBefore">^0808^</h3>
                <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LS_BLOCK/LIST_DATA" mode = "LS_BLOCK"/>
            </xsl:if>
                                                                	     
<!-- Scan Properties -->
            <h3 class = "breakBefore"> ^0403^ </h3>
            <table>   
               <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/SLI_BLOCK" mode = "nonrepeat"/>
            </table>
<!-- Scan List -->
			<xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/SLI_BLOCK" mode = "repeat" />
			

         </body>
      <xsl:text disable-output-escaping = "yes"> &lt;/meta> &lt;/html> </xsl:text>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "RI_BLOCK" >
      <tr>
         <td class = "left">
            <xsl:value-of select = "RI_MODELNUM/@DISPLAY_NAME" />
         </td>
         <td>
            <xsl:value-of select = "RI_MODELNUM" />
         </td>
      </tr>
      <tr>
         <td class = "left">
            <xsl:value-of select = "RI_SERIALNUM/@DISPLAY_NAME" />
         </td>
         <td>
            <xsl:value-of select = "RI_SERIALNUM" />
         </td>
      </tr>
      <tr>
         <td class = "left">
            <xsl:value-of select = "RI_BANDMINFREQ/@DISPLAY_NAME" />
         </td>
         <td>
            <xsl:value-of select = "RI_BANDMINFREQ" />-
            <xsl:value-of select = "RI_BANDMAXFREQ" />
         </td>
      </tr>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "TI_BLOCK" >
      <tr>
         <td class = "left">
            <xsl:value-of select = "TI_FIRMVER/@DISPLAY_NAME" />
         </td>
         <td>
            <xsl:value-of select = "TI_FIRMVER" />
         </td>
      </tr>
      <tr>
         <td class = "left">
            ^0412^
         </td>
         <td class = "bottom">
              <xsl:call-template name = "DATE">
              	<xsl:with-param name = "format">
                      ^0449^
                  </xsl:with-param>
             </xsl:call-template>             
            <xsl:variable name = "orighour">
               <xsl:value-of select = "substring-before(TI_LATTIME, ':')" />
            </xsl:variable>
            <xsl:variable name = "min">
               <xsl:value-of select = "substring-after(TI_LATTIME, ':')" />
            </xsl:variable>
            <xsl:choose>
               <xsl:when test = "$orighour = '00'">
                  <xsl:variable name = "newhour">
                     <xsl:value-of select = "12" />
                  </xsl:variable>
                  <xsl:variable name = "lateness">
                     AM
                  </xsl:variable>
                  <xsl:value-of select = "$newhour" />:<xsl:value-of select = "$min" /> <xsl:value-of select = "$lateness" />
               </xsl:when>
               <xsl:when test = "$orighour = '12'">
                  <xsl:variable name = "newhour">
                     <xsl:value-of select = "12" />
                  </xsl:variable>
                  <xsl:variable name = "lateness">
                     PM
                  </xsl:variable>
                  <xsl:value-of select = "$newhour" />:<xsl:value-of select = "$min" /> <xsl:value-of select = "$lateness" />
               </xsl:when>
               <xsl:when test = "$orighour > 12">
                  <xsl:variable name = "newhour">
                     <xsl:value-of select = "$orighour - 12" />
                  </xsl:variable>
                  <xsl:variable name = "lateness">
                     PM
                  </xsl:variable>
                  <xsl:value-of select = "$newhour" />:<xsl:value-of select = "$min" /> <xsl:value-of select = "$lateness" />
               </xsl:when>
               <xsl:otherwise>
                  <xsl:variable name = "newhour">
                     <xsl:value-of select = "$orighour" />
                  </xsl:variable>
                  <xsl:variable name = "lateness">
                     AM
                  </xsl:variable>
                  <xsl:value-of select = "$newhour"/>:<xsl:value-of select = "$min" /> <xsl:value-of select = "$lateness" />
               </xsl:otherwise>
            </xsl:choose>
         </td>
      </tr>
      <tr>
         <td class = "left">
            <xsl:value-of select = "TI_LATCPVER/@DISPLAY_NAME" />
         </td>
         <td>
            <xsl:value-of select = "TI_LATCPVER" />
         </td>
      </tr>
      <xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Mobile'">
      <tr>
         <td class = "left">
            ^3249^
         </td>
         <td>
            <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/X_RI_POWR_RANGE" />
         </td>
      </tr>
      </xsl:if>
   </xsl:template>

   <xsl:template name = "DATE">
      <xsl:param name = 'format' />
      <xsl:variable name = "date" >
         <xsl:value-of select = "TI_LATDATE" />
      </xsl:variable>
      <xsl:choose>
         <xsl:when test = "contains($format, 'YMD')" >
              <xsl:value-of select ="substring($date,7,4)" />/<xsl:value-of select ="substring($date,1,2)" />/<xsl:value-of select ="substring($date,4,2)" />,
         </xsl:when>
         <xsl:when test = "contains($format, 'DMY')" >
              <xsl:value-of select ="substring($date,4,2)" />/<xsl:value-of select ="substring($date,1,2)" />/<xsl:value-of select ="substring($date,7,4)" />,            
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select = "translate($date, '-', '/')" />,
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "RC_BLOCK" >  
      <xsl:if test = "../../../RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE != 'Portable'">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_HOTMICSRC/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_HOTMICSRC" />
            </td>
         </tr>         
      </xsl:if>
      <tr>
         <td class = "left">
            <xsl:value-of select = "RC_BUSYLEDEN/@DISPLAY_NAME" />:
         </td>
         <td>
            <xsl:value-of select = "RC_BUSYLEDEN" />
         </td>
      </tr>
      <xsl:if test = "../../../RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE != 'Portable'">
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_HUBDEFPL/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_HUBDEFPL" />
            </td>
         </tr>
      </xsl:if>
      <tr>
         <td class = "left">
            <xsl:value-of select = "RC_MICGAIN/@DISPLAY_NAME" />:
         </td>
         <td>
            <xsl:value-of select = "RC_MICGAIN" />
         </td>
      </tr>
      <tr>
         <td class = "left">
            <xsl:value-of select = "X_RC_FPT/@DISPLAY_NAME" />:
         </td>
         <td>
            <xsl:value-of select = "X_RC_FPT" />
         </td>
      </tr>
      <tr>
         <td class = "left">
            <xsl:value-of select = "RC_CPSPSWD/@DISPLAY_NAME" />:
         </td>
         <td>
            <xsl:value-of select = "RC_CPSPSWD" />
         </td>
      </tr>
      
      <!-- Added by Alice Wan, CCB410 -->
      <xsl:if test = "($RadioLockEnable = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_RADLOCKEN/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_RADLOCKEN"/>
            </td>
         </tr>         
      </xsl:if>      
      <!-- Added by Anna Kang, CCB430 -->
      <xsl:if test = "($RadioLockPermentalDisable = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_RADLOCKPERMENATALYDISABLE/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_RADLOCKPERMENATALYDISABLE"/>
            </td>
         </tr>         
      </xsl:if>
      
      <xsl:if test = "($RadioLockEnable = 'true')"> 
         <tr>
           <td class = "left">
              <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_RADLOCKPSWD/@DISPLAY_NAME" />:
           </td>
           <td>
              <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_RADLOCKPSWD"/>
           </td>
         </tr>
      </xsl:if>
      
      <xsl:if test = "($RadioNameEnable = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_RADIONAMEEN/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_RADIONAMEEN" />
            </td>
         </tr>       
      </xsl:if>  
 
      <xsl:if test = "($RadioNameEnable = 'true')">        
         <tr>
           <td class = "left">
              <xsl:value-of select = "RC_RADIONAME/@DISPLAY_NAME" />:
           </td>
           <td>
              <xsl:value-of select = "RC_RADIONAME"/>
           </td>
         </tr>
      </xsl:if>
      
      <xsl:if test = "($TxInhibitOverrideEnable = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_TXINHQUICKKEYEN/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_TXINHQUICKKEYEN" />
            </td>
         </tr>         
      </xsl:if>
      <!-- Added by Alice Wan, CCB410 -->
      
      <tr>
         <td class = "left">
            <xsl:value-of select = "RC_ALERTVOLOFFSET/@DISPLAY_NAME" />:
         </td>
         <td>
            <xsl:value-of select = "RC_ALERTVOLOFFSET" />
         </td>
      </tr>
      <!-- Monitor Type is a Portable Only Feature  RADsw07289 -->
      <xsl:if test = "../../../RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Portable'">
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_MONTYPE/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_MONTYPE" />
            </td>
         </tr>
      </xsl:if>
      <xsl:if test = "../../../RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Portable'">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_TXLOWBATLEDEN/@DISPLAY_NAME" />^0452^:
            </td>
            <td>
               <xsl:value-of select = "RC_TXLOWBATLEDEN" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_CLONEEN/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_CLONEEN" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_TXLOWBATALERTEN/@DISPLAY_NAME" />^0451^:
            </td>
            <td>
               <xsl:value-of select = "RC_TXLOWBATALERTEN" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_STPERMMONALERTEN/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_STPERMMONALERTEN" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_RXLOWBATALERTINT/@DISPLAY_NAME" />:
            </td>
            <td class = "bottom">
               <xsl:value-of select = "RC_RXLOWBATALERTINT" />
            </td>
         </tr>
      </xsl:if>
      <xsl:if test = "../../../RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE != 'Portable'">
         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_TXLOWPWR/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_TXLOWPWR" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_TXHIGHPWR/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_TXHIGHPWR" />
            </td>
         </tr>
      </xsl:if>

      <!-- New General Setting controls for Phase II -->
      <xsl:if test = "contains(X_MODEL, 'PLK') or
        	      contains(X_MODEL, 'PFK') or
                      contains(X_MODEL, 'MPLUS')">
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_HOMEREVPERINDEX1/@DISPLAY_NAME" />
            </td>
            <xsl:choose>
                <xsl:when test = "RC_HOMEREVPERINDEX1= '255'">
                    <td>^0602^</td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name = "index">
                           <xsl:value-of select = "RC_HOMEREVPERINDEX1" />
                    </xsl:variable>
                    <xsl:choose>
                        <xsl:when test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR != 1">
                            <td><xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS" /></td>
                        </xsl:when> 
                        <xsl:when test = "RC_HOMEREVPERTYPE1 = 'Conventional'">
                            <td>CNV <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS" /></td>
                        </xsl:when>
                        <xsl:when test = "RC_HOMEREVPERTYPE1 = 'LS Trunking'">
                            <td>LTR <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
                        </xsl:when>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_HOMEREVPERINDEX2/@DISPLAY_NAME" />
            </td>
            <xsl:choose>
                <xsl:when test = "RC_HOMEREVPERINDEX2= '255'">
                    <td>^0602^</td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name = "index">
                           <xsl:value-of select = "RC_HOMEREVPERINDEX2" />
                    </xsl:variable>
                    <xsl:choose>
                        <xsl:when test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR != 1">
                            <td><xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS" /></td>
                        </xsl:when> 
                        <xsl:when test = "RC_HOMEREVPERTYPE2 = 'Conventional'">
                            <td>CNV <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS" /></td>
                        </xsl:when>
                        <xsl:when test = "RC_HOMEREVPERTYPE2 = 'LS Trunking'">
                            <td>LTR <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
                        </xsl:when>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
         </tr>
      </xsl:if>   
      <xsl:if test = "contains(X_MODEL, 'PNK') or
        	      contains(X_MODEL, 'PLK') or
                      contains(X_MODEL, 'PFK') or
        	      (contains(X_MODEL, 'MARLIN') and /ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER &gt;= 2) or
                      contains(X_MODEL, 'MPLUS')">
         <tr>
            <td class = "left">
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_ESCALERTEN/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_ESCALERTEN" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_ALERTFIXVOLEN/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_ALERTFIXVOLEN" />
            </td>
         </tr>
      </xsl:if> 
      
      <!-- Added by Alice Wan, CCB410 -->
      <xsl:if test = "($ArtsEnable = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_ARTSMODE/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_ARTSMODE" />
            </td>
         </tr>         
      </xsl:if>      
      <xsl:if test = "($ArtsEnable = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_ARTSBEEP/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_ARTSBEEP" />
            </td>
         </tr>         
      </xsl:if>      
      <xsl:if test = "($ArtsEnable = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_ARTSTXTIME/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_ARTSTXTIME" />
            </td>
         </tr>         
      </xsl:if> 
      
      <!-- Added by Alice Wan, CCB410 2010-6-7 -->
      <xsl:if test = "($ArtsEnable = 'true') and ($IsDisplay = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_ARTSDISPLAY/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_ARTSDISPLAY" />
            </td>
         </tr>         
      </xsl:if> 
      
      <!-- Added by Anna Kang, CCB430 2010-12-24 -->
      <xsl:if test = "($ARTSPTTSideToneDisable = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_ARTPPTSIDETONEDISABLE/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_ARTPPTSIDETONEDISABLE" />
            </td>
         </tr>         
      </xsl:if> 
      
      
      <!-- Added by Alice Wan, CCB410 2010-6-7 -->
      
      <xsl:if test = "($LoneWorkerEnable = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_LONEWOKERRESPONSETIMER/@DISPLAY_NAME" />:
            </td>
            <td class = "bottom">
               <xsl:value-of select = "RC_LONEWOKERRESPONSETIMER" />
            </td>
         </tr>        
      </xsl:if> 
      <xsl:if test = "($LoneWorkerEnable = 'true')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_LONEWOKERREMINDTIMER/@DISPLAY_NAME" />:
            </td>
            <td class = "bottom">
               <xsl:value-of select = "RC_LONEWOKERREMINDTIMER" />
            </td>
         </tr>        
      </xsl:if> 
      <!-- Added by Alice Wan, CCB410 --> 
          
<!-- Power up channel-->   
      <xsl:if test = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER &gt;= 2 and /ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Mobile'">
         <tr>
            <td class = "left">
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_DESTPOWERUPCH/@DISPLAY_NAME" />
            </td>
            <td>
               <xsl:if test = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_DESTPOWERUPCH = '0'">
                  ^0602^
               </xsl:if>
               <xsl:if test = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_DESTPOWERUPCH != '0'">
		   <xsl:variable name = "index">
			<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_DESTPOWERUPCH" />
		   </xsl:variable>   
                   <xsl:variable name = "oldAlias">
                       <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/PA_BLOCK/X_PA_LIST/X_CHANNAL_ALIAS[position() = $index]" />
                   </xsl:variable>
                   <xsl:call-template name = "aliastransform">
                       <xsl:with-param name = "aliasname1">
                           <xsl:value-of select = "$oldAlias" />
                       </xsl:with-param>
                   </xsl:call-template>     		       
               </xsl:if>
            </td>
         </tr>
 </xsl:if> 
	<!-- Added by SamLee, CCB356 --> 
      	<xsl:variable name = "cpver">
          	<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
      	</xsl:variable>
	<xsl:if test= "($cpver >= '07.00') and contains($m_ProductLine, 'ELT_Conv')">      	
		<xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Mobile'">		
         <tr>
            <td class = "left">
               <xsl:value-of select = "RC_SELFTESTREPORTEN/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "RC_SELFTESTREPORTEN" />
            </td>
         </tr>
 		</xsl:if>   
 	</xsl:if>   
	<!-- Added end -->

	<!-- Added by Xiao Yuek, CCB393 -->
	   <xsl:variable name = "MDFRussianFlag">
		   <xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RUSSIAN_EN"/>
	   </xsl:variable>
	   
	   <xsl:variable name ="RegionID">
		   <xsl:value-of select="/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID"/>
	   </xsl:variable>	   
	 
	   <xsl:variable name ="RussianEnable">
		   <xsl:value-of select="($cpver >= '08.00') and ($RegionID = 'EMEA') and ($MDFRussianFlag = '1')"/>
	   </xsl:variable>
	   
	   <xsl:if test="$RussianEnable = 'true'">
		   <tr>
			   <td class = "left">
				   <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_LANGSEL/@DISPLAY_NAME" />:
			   </td>
			   <td>
				   <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_LANGSEL"/>
			   </td>
		   </tr>
	   </xsl:if>
   <!-- End for CCB393 -->
   </xsl:template>


   <xsl:template match = "ENTRY_DATA" mode = "CBP_BLOCK" >
      <tr>
         <td class = "left">
            <xsl:value-of select = "../../RC_BLOCK/ENTRY_DATA/RC_LONGPRESSDUR/@DISPLAY_NAME" />:
         </td>
         <td>
            <xsl:value-of select = "../../RC_BLOCK/ENTRY_DATA/RC_LONGPRESSDUR" />
         </td>
      </tr>
      <xsl:if test = "../../../RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Mobile'">
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_P1SHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "X_CBM_P1SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_P1LONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "X_CBM_P1LONGPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_P2SHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "X_CBM_P2SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_P2LONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "X_CBM_P2LONGPRESS" />
            </td>
         </tr>
<xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">         
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_P3SHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBM_P3SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_P3LONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBM_P3LONGPRESS" />
            </td>
         </tr>

         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_P4SHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBM_P4SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_P4LONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBM_P4LONGPRESS" />
            </td>
         </tr>
</xsl:if>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_MICASHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "X_CBM_P3SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_MICALONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "X_CBM_P3LONGPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_MICBSHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "X_CBM_P4SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_MICBLONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "X_CBM_P4LONGPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_MICCSHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "X_CBM_P5SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBM_MICCLONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "X_CBM_P5LONGPRESS" />
            </td>
         </tr>
      </xsl:if>

      <xsl:if test = "../../../RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Portable'">
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBP_SIDE1SHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBP_SIDE1SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBP_SIDE1LONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBP_SIDE1LONGPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBP_SIDE2SHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBP_SIDE2SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBP_SIDE2LONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBP_SIDE2LONGPRESS" />
            </td>
         </tr>
<xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK')" >
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBP_FRONT1SHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBP_FRONT1SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBP_FRONT1LONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBP_FRONT1LONGPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBP_FRONT3SHORTPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBP_FRONT3SHORTPRESS" />
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "CBP_FRONT3LONGPRESS/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "CBP_FRONT3LONGPRESS" />
            </td>
         </tr>
</xsl:if>
      </xsl:if>
   </xsl:template>

   <xsl:template match = "CP_BLOCK">
      <xsl:variable name = "start">1</xsl:variable>
      <xsl:variable name = "end">
         <xsl:value-of select = "count(ENTRY_DATA)" />
      </xsl:variable>
      <xsl:variable name = "cycle">
         <xsl:value-of select = "ceiling( $end div 8  )" />
      </xsl:variable>

      <xsl:if test = "$cycle &gt;= 1">
         <h3 class = "breakBefore"> ^0402^ </h3>
            <xsl:call-template name = "PERS_TABLE">
                <xsl:with-param name = "startIndex">1</xsl:with-param>
                <xsl:with-param name = "endIndex">8</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 2">
         <h3 class = "breakBefore"> ^0402^ </h3>
            <xsl:call-template name = "PERS_TABLE">
                <xsl:with-param name = "startIndex">9</xsl:with-param>
                <xsl:with-param name = "endIndex">16</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 3">
         <h3 class = "breakBefore"> ^0402^ </h3>
            <xsl:call-template name = "PERS_TABLE">
                <xsl:with-param name = "startIndex">17</xsl:with-param>
                <xsl:with-param name = "endIndex">24</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 4">
         <h3 class = "breakBefore"> ^0402^ </h3>
            <xsl:call-template name = "PERS_TABLE">
                <xsl:with-param name = "startIndex">25</xsl:with-param>
                <xsl:with-param name = "endIndex">32</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 5">
         <h3 class = "breakBefore"> ^0402^ </h3>
            <xsl:call-template name = "PERS_TABLE">
                <xsl:with-param name = "startIndex">33</xsl:with-param>
                <xsl:with-param name = "endIndex">40</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 6">
         <h3 class = "breakBefore"> ^0402^ </h3>
            <xsl:call-template name = "PERS_TABLE">
                <xsl:with-param name = "startIndex">41</xsl:with-param>
                <xsl:with-param name = "endIndex">48</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 7">
         <h3 class = "breakBefore"> ^0402^ </h3>
            <xsl:call-template name = "PERS_TABLE">
                <xsl:with-param name = "startIndex">49</xsl:with-param>
                <xsl:with-param name = "endIndex">56</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 8">
         <h3 class = "breakBefore"> ^0402^ </h3>
            <xsl:call-template name = "PERS_TABLE">
                <xsl:with-param name = "startIndex">57</xsl:with-param>
                <xsl:with-param name = "endIndex">64</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
            <xsl:if test = "$cycle &gt;= 9">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">65</xsl:with-param>
                      <xsl:with-param name = "endIndex">72</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 10">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">73</xsl:with-param>
                      <xsl:with-param name = "endIndex">80</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 11">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">81</xsl:with-param>
                      <xsl:with-param name = "endIndex">88</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 12">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">89</xsl:with-param>
                      <xsl:with-param name = "endIndex">96</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 13">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">97</xsl:with-param>
                      <xsl:with-param name = "endIndex">104</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            
            <xsl:if test = "$cycle &gt;= 14">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">105</xsl:with-param>
                      <xsl:with-param name = "endIndex">112</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            
            <xsl:if test = "$cycle &gt;= 15">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">113</xsl:with-param>
                      <xsl:with-param name = "endIndex">120</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            
            <xsl:if test = "$cycle &gt;= 16">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">121</xsl:with-param>
                      <xsl:with-param name = "endIndex">128</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
   </xsl:template>

   <xsl:template name = "PERS_TABLE">
         <xsl:param name = "startIndex">1</xsl:param>
         <xsl:param name = "endIndex">8</xsl:param>
         <xsl:param name = "break">no</xsl:param>
         <xsl:if test = "$break = 'no'">
            <xsl:text disable-output-escaping = "yes">
               &lt;table>
            </xsl:text>
         </xsl:if>
         <xsl:if test = "$break = 'yes'">
            <xsl:text disable-output-escaping = "yes">
               &lt;table class = "solo">
            </xsl:text>
         </xsl:if>
         <tr>
            <xsl:text disable-output-escaping = "yes">
               &lt;th width = "25%"> &amp;nbsp &lt;/th>
            </xsl:text>       
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_ALIAS" />
         </tr>
         <tr> 
            <td class = "em">
               ^0803^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_CHNNELPOSITION">
                <xsl:with-param name = 'start' select = '$startIndex'/>
            </xsl:apply-templates>
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select="ENTRY_DATA/CP_CHBWSEL/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_CHBWSEL"/>
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select="ENTRY_DATA/CP_SCANLISTINDEX/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_SCANLISTINDEX" />
         </tr>
         <tr>
            <td class = "em">
              <xsl:value-of select="ENTRY_DATA/CP_AUTOSCANEN/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_AUTOSCANEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select="ENTRY_DATA/X_CP_COMPANDING/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_COMPANDING" />
         </tr>
	<xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani'))">
         <tr>
            <td class = "em">
               <xsl:value-of select="ENTRY_DATA/CP_TALKAROUNDEN/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TALKAROUNDEN" />
         </tr>  
        </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select="ENTRY_DATA/CP_RXONLY/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXONLY"/>
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select="ENTRY_DATA/CP_EMPSEL/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_EMPSEL" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select="ENTRY_DATA/CP_SQSET/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_SQSET" />
         </tr>

         <xsl:choose>
            <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'PFK') or
			      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'PLK') or
			      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'MPLUS') ">
              <tr>
                  <td class = "em">
                     <xsl:value-of select="ENTRY_DATA/CP_PHSYSINDEX/@DISPLAY_NAME" />
                  </td>                  
                  <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_PHSYSINDEX" />
               </tr>
            </xsl:when>
         </xsl:choose>

         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PNK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PLK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PFK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'MPLUS')">
           <tr>
              <td class = "em">
                 <xsl:value-of select="ENTRY_DATA/CP_OPTBRDFEATEN/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_OPTBRDFEATEN" />
           </tr>
         </xsl:if>
         
       <!-- PCCB1-Alice -->
      	<xsl:variable name = "cpver">
          	<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
      	</xsl:variable>
      	
      	<xsl:if test= "$cpver >= '05.00' ">      	
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PNK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PLK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PFK')">
           <tr>
              <td class = "em">
                 <xsl:value-of select="ENTRY_DATA/CP_FLATTXAUDIOEN/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_FLATTXAUDIOEN" />
           </tr>
         </xsl:if>
       </xsl:if>
      <!-- PCCB1-Alice -->
         
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PNK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PLK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PFK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'MPLUS')">
           <tr>
              <td class = "em">
                 <xsl:value-of select="ENTRY_DATA/CP_OPTBRDCONFIGINDEX/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_OPTBRDCONFIGINDEX" />
           </tr>
         </xsl:if>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MARLIN')">
           <tr>
              <td class = "em">
                 <xsl:value-of select="ENTRY_DATA/CP_DATAREVERTPERINDEX/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_DATAREVERTPERINDEX" />
           </tr>
         </xsl:if>
           <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_SDT, '1')">
               <tr>
	            <td class = "em">
	               <xsl:value-of select = "ENTRY_DATA/CP_DATATRANSOB/@DISPLAY_NAME" />:
	            </td>
              	    <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_DATATRANSOB" />
               </tr>
          </xsl:if>
          
        <!-- Added by Alice Wan, CCB410 -->     	
        <xsl:if test = "($ArtsEnable = 'true')">
           <tr>
              <td class = "em">
                 <xsl:value-of select="ENTRY_DATA/CP_ARTSEN/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_ARTSEN" />
           </tr>
        </xsl:if>
        
        <xsl:if test = "($LoneWorkerEnable = 'true')">
           <tr>
              <td class = "em">
                 <xsl:value-of select="ENTRY_DATA/CP_LONEWOKEREN/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_LONEWOKEREN" />
           </tr>
        </xsl:if>
        <!-- Added by Alice Wan, CCB410 -->

         <!-- Rx Parameters -->
         <tr>
            <td class = "em1">
               ^0302^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "counting_space" />
         </tr>
         <tr>
            <td class = "em">
               ^0317^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXFREQ"/>
         </tr>
         <tr>
            <td class = "em">
               ^0319^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXSQCODESEL"/>
         </tr>            
         <tr>
            <td class = "em">
               ^0305^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXDECDATA_DPL"/>
         </tr>
         <tr>
            <td class = "em">
               ^0321^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXDPLINVERT"/>
         </tr>         
         <tr>
            <td class = "em">
               ^0303^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXDECDATA_TPL" />
         </tr>
         <tr>
            <td class = "em">
               ^0304^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_RX_TPL_CODE" />
         </tr>
	        <xsl:if test="not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KCC9AA1AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50KCC9AA2AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50RCC9AA1AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50RCC9AA2AN')) ">
	         <tr>
	            <td class = "em">
	               ^0325^
	            </td>                  
	            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" 	mode = "CP_RXSIGTYPE" />
	         </tr>
         
         <tr>
            <td class = "em">
               <xsl:value-of select="ENTRY_DATA/CP_PLREQFORDATA/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_PLREQFORDATA" />
         </tr>            
         
	         <tr>
	            <td class = "em">
	               <xsl:value-of select="ENTRY_DATA/CP_SIGSQ/@DISPLAY_NAME" />
	            </td>                  
	            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" 	mode = "CP_SIGSQ" />
	         </tr>
	 </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select="ENTRY_DATA/CP_UNMUTETYPE/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_UNMUTETYPE" />
         </tr>
         <tr>
           <td class = "em">
               ^0329^
           </td>                  
           <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXREFFREQ" />
         </tr>
         <tr>
            <td class = "em1">
               ^0306^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "counting_space" />
         </tr>
         <tr>
            <td class = "em">
               ^0318^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXFREQ"/>
         </tr>         
         <tr>
            <td class = "em">
               ^0320^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXSQCODESEL"/>
         </tr>         
         <tr>
            <td class = "em">
               ^0309^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXENCDATA_DPL"/>
         </tr>         
         <tr>
            <td class = "em">
               ^0322^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXDPLINVERT"/>
         </tr>         
         <tr>
            <td class = "em">
               ^0307^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXENCDATA_TPL"/>
         </tr>
         <tr>
            <td class = "em">
               ^0308^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_TX_TPL_CODE"/> 
         </tr>         
         <xsl:if test="not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KCC9AA1AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50KCC9AA2AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50RCC9AA1AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50RCC9AA2AN')) ">
	         <tr>
	            <td class = "em">
	               ^0326^
	            </td>                  
	            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" 	mode = "CP_TXSIGTYPE" />
	         </tr>         
	         <tr>
	            <td class = "em">
	               <xsl:value-of select="ENTRY_DATA/CP_TXPWRLEVSEL/@DISPLAY_NAME" />
	            </td>          
	            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" 	mode = "CP_TXPWRLEVSEL" />
	         </tr>
	 </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select="ENTRY_DATA/CP_VOXEN/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_VOXEN" />
         </tr>

         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA')">
            <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'PFK') or
			                   contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'PLK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'PNK')">
              <tr>
                  <td class = "em">
                     <xsl:value-of select="ENTRY_DATA/X_CP_WHISPER/@DISPLAY_NAME" />
                  </td>                  
                  <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_WHISPER" />
               </tr>
            </xsl:if>
         </xsl:if>
         
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA')">
			 <tr>
				<td class = "em">
				   <xsl:value-of select="ENTRY_DATA/CP_TOTTYPE/@DISPLAY_NAME" />
				</td>                  
				<xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TOTTYPE" />
			 </tr>
		 </xsl:if>
         <xsl:choose>
            <xsl:when test = "ENTRY_DATA/CP_TOTTYPE = '^0627^'">
               <tr>
                  <td class = "em">
                     <xsl:value-of select="ENTRY_DATA/CP_TOT/@DISPLAY_NAME" />
                  </td>                  
                  <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TOT" />
               </tr>            
            </xsl:when>
            <xsl:otherwise>
               <tr>
                  <td class = "em">
                     <xsl:value-of select="ENTRY_DATA/CP_TOT/@DISPLAY_NAME" />
                  </td>                  
                  <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TOT" />
               </tr>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:choose>
            <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PNK') or 
                              contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or 
                              contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or 
                              contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MARLIN') or 
                              contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') or
                              (contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA') and contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'GUPPY')) ">
              <tr>
                  <td class = "em">
                     <xsl:value-of select="ENTRY_DATA/CP_RESETDURINHDUR/@DISPLAY_NAME" />
                  </td>                  
                  <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RESETDURINHDUR" />
               </tr>
            </xsl:when>
         </xsl:choose>

         <tr>
            <td class = "em">
               ^0330^
            </td>                  
            <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXREFFREQ" />
         </tr>
         <tr>
            <td class = "em">
               ^0324^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "TX_DPL_TURNOFF_CODE"/>
         </tr>
         <tr>
            <td class = "em">
               ^0323^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_REVBURST"/>
         </tr>                  
         <xsl:choose>
		      <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA')">
				   <!-- Extended EMEA List -->
					 <tr>
						<td class = "em">
						   ^0332^
						</td>                  
						<xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXADMITCRITERIA" />
					 </tr>
			   </xsl:when>
			<xsl:otherwise>
				<tr>
					<td class = "em">
					   <xsl:value-of select="ENTRY_DATA/CP_BUSYCHLKOUT/@DISPLAY_NAME" />
					</td>                  
					<xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_BUSYCHLKOUT" />
				 </tr>
			</xsl:otherwise>
		</xsl:choose>

      <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA')">
        <tr>
           <td class = "em">
              <xsl:value-of select="ENTRY_DATA/CP_CARRIERTIMERDUR/@DISPLAY_NAME" />
           </td>                  
           <xsl:apply-templates select="ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_CARRIERTIMERDUR" />
         </tr>
      </xsl:if>
      
      <xsl:text disable-output-escaping = "yes">
               &lt;/table>
      </xsl:text>
   </xsl:template>
      

	<xsl:template match = "SLI_BLOCK" mode = "nonrepeat">
         <tr>
            <td class = "em">
               <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_SCANHANGTIME/@DISPLAY_NAME" />
            </td>
            <td>
               <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_SCANHANGTIME" />
            </td>
         </tr>
        <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani'))">
         <tr>
            <td class = "em">
               <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_PRISCANALERTEN/@DISPLAY_NAME" />
            </td>
            <td>
               <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_PRISCANALERTEN" />
            </td>
         </tr>
        </xsl:if>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MARLIN') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PNK') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'GUPPY') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'G2W')" >
            <tr>
               <td class = "em">
                  <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_SCANCHDISCALERTEN/@DISPLAY_NAME" />
               </td>
               <td>
                  <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_SCANCHDISCALERTEN" />
               </td>
            </tr>
         </xsl:if>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MARLIN') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
            <tr>
               <td class = "em">
                  <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_HUBSUSSCAN/@DISPLAY_NAME" />
               </td>
               <td>
	               <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_HUBSUSSCAN" />
	            </td>
            </tr>
         </xsl:if>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK')">
            <tr>
               <td class = "em">
                  <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_REVERTSCAN/@DISPLAY_NAME" />
               </td>
               <td>
	               <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_REVERTSCAN" />
	            </td>
            </tr>                  
         </xsl:if>
         <!-- CCB370-Alice -->
         <xsl:variable name = "cpver">
          	<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
      	 </xsl:variable>
      	
         <xsl:if test= "$cpver >= '06.00' ">      	
            <tr>
              <td class = "em">
                 <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_SELCHANLOCK/@DISPLAY_NAME" />
              </td>
              <td>
                 <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_SELCHANLOCK" />
              </td>
            </tr>
         </xsl:if>
         <xsl:if test= "$cpver >= '06.00' ">      	
             <tr>
              <td class = "em">
                 <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_PRIOCHANLOCK/@DISPLAY_NAME" />
              </td>
              <td>
                 <xsl:value-of select = "../RC_BLOCK/ENTRY_DATA/RC_PRIOCHANLOCK" />
              </td>
            </tr>
         </xsl:if>
         <!-- CCB370-Alice -->
         <tr />
	</xsl:template>

	<xsl:template match = "SLI_BLOCK" mode = "repeat">
      <xsl:variable name = "start">1</xsl:variable>
      <xsl:variable name = "end">
         <xsl:value-of select = "count(LIST_DATA)" />
      </xsl:variable>
      <xsl:variable name = "cycle">
         <xsl:value-of select = "ceiling(  count(LIST_DATA) div 8  )" />
      </xsl:variable>

      <xsl:if test = "$cycle &gt;= 1">
            <xsl:call-template name = "SLI_TABLE">
                <xsl:with-param name = "startIndex">0</xsl:with-param>
                <xsl:with-param name = "endIndex">8</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 2">
            <xsl:call-template name = "SLI_TABLE">
                <xsl:with-param name = "startIndex">9</xsl:with-param>
                <xsl:with-param name = "endIndex">16</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
	</xsl:template>

    <xsl:template name = "SLI_TABLE" >
      <xsl:param name = "startIndex">1</xsl:param>
      <xsl:param name = "endIndex">8</xsl:param>
      <xsl:param name = "break">no</xsl:param>
      <xsl:if test = "$break = 'no'">
         <xsl:text disable-output-escaping = "yes">
            &lt;table>
         </xsl:text>
      </xsl:if>
      <xsl:if test = "$break = 'yes'">
         <xsl:text disable-output-escaping = "yes">
            &lt;table class = "solo">
         </xsl:text>
      </xsl:if>
         <tr>
               <xsl:text disable-output-escaping = "yes">
                  &lt;th> &amp;nbsp &lt;/th>
               </xsl:text>       
            <xsl:apply-templates select = "LIST_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]/ENTRY_INFO" mode = "counting_sli" />   
         </tr> 
         <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani'))">
	   <tr>
            <td class = "em">
               <xsl:value-of select = "LIST_DATA/ENTRY_INFO/SLI_TALKBACK/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "LIST_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]/ENTRY_INFO" mode = "SLI_TALKBACK" />
          </tr>
        </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select = "LIST_DATA/ENTRY_INFO/SLI_PLSCANTYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "LIST_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]/ENTRY_INFO" mode = "SLI_PLSCANTYPE" />
         </tr>
        <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani'))">
         <tr>
            <td class = "em">
               <xsl:value-of select = "LIST_DATA/ENTRY_INFO/SLI_PRISAMPTIME/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "LIST_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]/ENTRY_INFO" mode = "SLI_PRISAMPTIME" />
         </tr>
        </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select = "LIST_DATA/ENTRY_INFO/SLI_SIGHOLDTIME/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "LIST_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]/ENTRY_INFO" mode = "SLI_SIGHOLDTIME" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "LIST_DATA/ENTRY_INFO/SLI_PLSCANLKOUTEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "LIST_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]/ENTRY_INFO" mode = "SLI_PLSCANLKOUTEN" />
         </tr>
         
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
            <tr>
               <td class = "em">
                  <xsl:value-of select = "LIST_DATA/ENTRY_INFO/SLI_DESTXPERSINDEX/@DISPLAY_NAME" />
               </td>
               <xsl:apply-templates select = "LIST_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]/ENTRY_INFO" mode = "SLI_DESTXPERSINDEX" />
            </tr>
         </xsl:if>         
         <xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR = 1">
            <tr>
               <td class = "em">
                  <xsl:value-of select = "LIST_DATA/ENTRY_INFO/SLI_LTRSCANACTSRCHTIME/@DISPLAY_NAME" />
               </td>
               <xsl:apply-templates select = "LIST_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]/ENTRY_INFO" mode = "SLI_LTRSCANACTSRCHTIME" />
            </tr>
         </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select = "X_SLI_SCANLIST/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "X_SLI_SCANLIST[position() &gt;= $startIndex and position() &lt;= $endIndex]"/>
         </tr>
      <xsl:text disable-output-escaping = "yes">
         &lt;/table>
      </xsl:text>
   </xsl:template>

   <xsl:template match = "X_SLI_SCANLIST">
      <td>
         <xsl:apply-templates select = "X_MEMBER[@PRIORITY = '1']" mode = "p1"/>
         <xsl:apply-templates select = "X_MEMBER[@PRIORITY = '2']" mode = "p2"/>
         <xsl:apply-templates select = "X_MEMBER[@PRIORITY = '0']" mode = "p0">
            <xsl:sort order = "ascending" lang = "en" case-order = "lower-first" select = "." />
         </xsl:apply-templates><br/>
      </td>
   </xsl:template>

   <xsl:template match = "X_MEMBER" mode = "p1">
      <xsl:variable name = "oldAlias">
                   <xsl:value-of select="." />
      </xsl:variable>
      <xsl:call-template name = "aliastransform">
                   <xsl:with-param name = "aliasname1">
                       <xsl:value-of select = "$oldAlias" />
                   </xsl:with-param>
      </xsl:call-template>
      <img src = "scan1.jpg" align = "top"/>
      <br/>
   </xsl:template>

   <xsl:template match = "X_MEMBER" mode = "p2">
      <xsl:variable name = "oldAlias">
                   <xsl:value-of select="." />
      </xsl:variable>
      <xsl:call-template name = "aliastransform">
                   <xsl:with-param name = "aliasname1">
                       <xsl:value-of select = "$oldAlias" />
                   </xsl:with-param>
      </xsl:call-template>
      <img src = "scan2.jpg" align = "top"/>
      <br/>
   </xsl:template>

   <xsl:template match = "X_MEMBER" mode = "p0">
      <xsl:variable name = "oldAlias">
                   <xsl:value-of select="." />
      </xsl:variable>
      <xsl:call-template name = "aliastransform">
                   <xsl:with-param name = "aliasname1">
                       <xsl:value-of select = "$oldAlias" />
                   </xsl:with-param>
      </xsl:call-template>
      <br/>
   </xsl:template>

   <xsl:template match = "ENTRY_INFO" mode = "counting_sli">
      <th>
         <xsl:apply-templates select = "ALIAS"/>
      </th>
   </xsl:template>

   <xsl:template match = "ENTRY_INFO" mode = "SLI_PLSCANLKOUTEN">
      <td>
         <xsl:value-of select = "SLI_PLSCANLKOUTEN" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_INFO" mode = "SLI_SIGHOLDTIME">
      <td>
         <xsl:value-of select = "SLI_SIGHOLDTIME"/>
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_INFO" mode = "SLI_PRISAMPTIME">
      <td>
         <xsl:value-of select = "SLI_PRISAMPTIME"/>
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_INFO" mode = "SLI_DESTXPERSINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "SLI_DESTXPERSINDEX" />
      </xsl:variable>
      <td>
         <xsl:choose>
            <xsl:when test = "SLI_DESTXPERSTYPE = 'Selected'">
               Selected
            </xsl:when>            
            <xsl:when test = "SLI_DESTXPERSTYPE = 'Last Active'">
               ^0450^
            </xsl:when>
            <xsl:when test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR != 1">
                <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index + 1)]/ALIAS" />
            </xsl:when> 
            <xsl:when test = "SLI_DESTXPERSTYPE = 'LS Trunking'">
		LTR <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA[position() = ($index+1)]/ALIAS"/>
            </xsl:when>
            <xsl:when test = "SLI_DESTXPERSTYPE = 'Conventional'">
                CNV <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index + 1)]/ALIAS" />
            </xsl:when>
         </xsl:choose>
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_INFO" mode = "SLI_LTRSCANACTSRCHTIME">
      <td>
          <xsl:value-of select = "SLI_LTRSCANACTSRCHTIME" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_INFO" mode = "SLI_PLSCANTYPE">
      <td>
         <xsl:value-of select = "SLI_PLSCANTYPE"/>
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_INFO" mode = "SLI_TALKBACK">
      <td>
         <xsl:value-of select = "SLI_TALKBACK"/>
      </td>
   </xsl:template>
   
   <!-- Added by Alice Wan, CCB410 -->   
   <xsl:variable name = "cpver">
	<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
   </xsl:variable>
	
   <!-- Added by Alice Wan, CCB410 2010-6-7 -->	  	   	 
   <xsl:variable name ="MdcEmerEnable">
	<xsl:value-of select="($cpver >= '09.00') 
	and contains($m_ProductLine, 'ELT_Conv')
        and contains(/ELP_ELM_CODEPLUG/RRW/TC_BLOCK/EMDC_BLOCK, '1')"/>
   </xsl:variable>
   
   <xsl:variable name = "MDFMdcCallAlertDecFlag">
	<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_MDCCALLALERTDECODE"/>
   </xsl:variable>	   	 
   <xsl:variable name ="MdcCallAlertDecEnable">
	<xsl:value-of select="($cpver >= '09.00')
	and contains($m_ProductLine, 'ELT_Conv')
        and ($MDFMdcCallAlertDecFlag = '1')"/>
   </xsl:variable>   
   
   <xsl:variable name = "MDFArtsFlag">
	<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_ARTS"/>
   </xsl:variable>	   	 
   <xsl:variable name ="ArtsEnable">
	<xsl:value-of select="($cpver >= '09.00')
	and contains($m_ProductLine, 'ELT_Conv')
	and ($MDFArtsFlag = '1')"/>
   </xsl:variable> 
   
   <xsl:variable name = "MDFRadioLockFlag">
	<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADIOLOCK"/>
   </xsl:variable>	   	 
   <xsl:variable name ="RadioLockEnable">
	<xsl:value-of select="($cpver >= '09.00')
	and contains($m_ProductLine, 'ELT_Conv')
	and ($MDFRadioLockFlag = '1')"/>
   </xsl:variable> 
   <!-- Added by Anna , CCB430 2010-12-24 -->	
   <xsl:variable name ="RadioLockPermentalDisable">
	<xsl:value-of select="($cpver >= '10.00')
	and contains($m_ProductLine, 'ELT_Conv')
	and ($MDFRadioLockFlag = '1')"/>
   </xsl:variable> 
   
   <xsl:variable name = "MDFTxInhibitOverrideFlag">
	<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_TXINHIBITOVERRIDE"/>
   </xsl:variable>	   	 
   <xsl:variable name ="TxInhibitOverrideEnable">
	<xsl:value-of select="($cpver >= '09.00')
	and contains($m_ProductLine, 'ELT_Conv')
	and ($MDFTxInhibitOverrideFlag = '1')"/>
   </xsl:variable> 
   
   <xsl:variable name = "MDFLoneWorkerFlag">
	<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LONEWOKER"/>
   </xsl:variable>	   	 
   <xsl:variable name ="LoneWorkerEnable">
	<xsl:value-of select="($cpver >= '09.00')
	and contains($m_ProductLine, 'ELT_Conv')
	and ($MDFLoneWorkerFlag = '1')"/>
   </xsl:variable>
   
   <xsl:variable name = "MDFRadioNameFlag">
	<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADIONAME"/>
   </xsl:variable>	   	 
   <xsl:variable name ="RadioNameEnable">
	<xsl:value-of select="($cpver >= '09.00')
	and contains($m_ProductLine, 'ELT_Conv')
	and ($MDFRadioNameFlag = '1')"/>
   </xsl:variable>
   
   <xsl:variable name = "MDFToneTaggingFlag">
	<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_TONGTAGGING"/>
   </xsl:variable>	   	 
   <xsl:variable name ="ToneTaggingEnable">
	<xsl:value-of select="($cpver >= '09.00')
	and contains($m_ProductLine, 'ELT_Conv')
	and ($MDFToneTaggingFlag = '1')"/>
   </xsl:variable>
   
   <xsl:variable name = "MDFDispType">
	<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_DISPTYPE"/>
   </xsl:variable>  
   <xsl:variable name ="IsDisplay">
	<xsl:value-of select="($MDFDispType != 'None')"/>
   </xsl:variable> 
   <!-- Added by Alice Wan, CCB410 2010-6-7 -->2010-6-8 16:02
   <!-- Added by Alice Wan, CCB410 -->	
   
   <!-- Added by Alice Wan, CCB410 2010-7-20 -->
   <xsl:variable name = "MDFVoiceScramblingFlag">
	<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_VOICESCRAMBLING"/>
   </xsl:variable>	   	 
   <xsl:variable name ="VoiceScramblingEnable">
	<xsl:value-of select="($cpver >= '09.00')
	and contains($m_ProductLine, 'ELT_Conv')
	and ($MDFVoiceScramblingFlag = '1')"/>
   </xsl:variable>
   <!-- Added by Anna Kang, CCB430 2010-12-24 -->
   <xsl:variable name ="ARTSPTTSideToneDisable">
	<xsl:value-of select="($cpver >= '10.00')
	and contains($m_ProductLine, 'ELT_Conv')
	and ($MDFArtsFlag = '1')"/>
   </xsl:variable>
   
   <!-- Added by Alice Wan, CCB410 2010-7-20 -->
                   
   <xsl:template match = "ENTRY_DATA" mode = "SC_BLOCK" >
      <tr>
         <td class = "left">
            <xsl:value-of select = "SC_AUTORESETTIMER/@DISPLAY_NAME" />:
         </td>
         <td>
            <xsl:value-of select = "SC_AUTORESETTIMER" />
         </td>
      </tr>  
   </xsl:template>

   <xsl:template match = "RRW" mode = "AC_BLOCK" >
      <tr>
         <td colspan = "3" class = "left2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_HANDSETEN/@DISPLAY_NAME" />:
         </td>
         <td colspan = "2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_HANDSETEN" />
         </td>
      </tr>
      <tr>
         <td  colspan = "3" class = "left2">
           <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_ACCCONPACKID/@DISPLAY_NAME" />:
         </td>
         <td colspan = "2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_ACCCONPACKID" />
         </td>
      </tr>

     <tr>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN3FUNCSEL/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN3FUNCSEL" />
         </td>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN3ACTLEV/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN3ACTLEV" />
         </td>          
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN3DEBEN/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:choose>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN3DEBEN = '0'">
                ^0000^
              </xsl:when>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN3DEBEN = '1'">
                ^0001^
              </xsl:when>			   	
            </xsl:choose>           
         </td>
     </tr>	 	

     <tr>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN4FUNCSEL/@DISPLAY_NAME" />:
         </td>
         <td  class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN4FUNCSEL" />
         </td>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN4ACTLEV/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN4ACTLEV" />
         </td>          
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN4DEBEN/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:choose>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN4DEBEN = '0'">
                ^0000^
              </xsl:when>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN4DEBEN = '1'">
                ^0001^
              </xsl:when>			   	
            </xsl:choose>
         </td>
     </tr>

     <tr>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN6FUNCSEL/@DISPLAY_NAME" />:
         </td>
         <td  class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN6FUNCSEL" />
         </td>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN6ACTLEV/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN6ACTLEV" />
         </td>          
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN6DEBEN/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:choose>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN6DEBEN = '0'">
                ^0000^
              </xsl:when>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN6DEBEN = '1'">
                ^0001^
              </xsl:when>			   	
            </xsl:choose>
         </td>
     </tr>

     <tr>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN8FUNCSEL/@DISPLAY_NAME" />:
         </td>
         <td  class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN8FUNCSEL" />
         </td>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN8ACTLEV/@DISPLAY_NAME" />:
         </td>
         <td  class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN8ACTLEV" />
         </td>          
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN8DEBEN/@DISPLAY_NAME" />:
         </td>
         <td  class="repeat">
            <xsl:choose>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN8DEBEN = '0'">
                ^0000^
              </xsl:when>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN8DEBEN = '1'">
                ^0001^
              </xsl:when>			   	
            </xsl:choose>
         </td>
     </tr>

     <tr>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN9FUNCSEL/@DISPLAY_NAME" />:
         </td>
         <td  class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN9FUNCSEL" />
         </td>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN9ACTLEV/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN9ACTLEV" />
         </td>          
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN9DEBEN/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:choose>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN9DEBEN = '0'">
                ^0000^
              </xsl:when>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN9DEBEN = '1'">
                ^0001^
              </xsl:when>			   	
            </xsl:choose>
         </td>
     </tr>

     <tr>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN12FUNCSEL/@DISPLAY_NAME" />:
         </td>
         <td  class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN12FUNCSEL" />
         </td>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN12ACTLEV/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN12ACTLEV" />
         </td>          
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN12DEBEN/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:choose>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN12DEBEN = '0'">
                ^0000^
              </xsl:when>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN12DEBEN = '1'">
                ^0001^
              </xsl:when>			   	
            </xsl:choose>
         </td>
     </tr>

     <tr>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN14FUNCSEL/@DISPLAY_NAME" />:
         </td>
         <td  class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN14FUNCSEL" />
         </td>
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN14ACTLEV/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN14ACTLEV" />
         </td>          
         <td class = "left">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_PIN14DEBEN/@DISPLAY_NAME" />:
         </td>
         <td class="repeat">
            <xsl:choose>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN14DEBEN = '0'">
                ^0000^
              </xsl:when>
              <xsl:when test = "AC_BLOCK/ENTRY_DATA/AC_PIN14DEBEN = '1'">
                ^0001^
              </xsl:when>			   	
            </xsl:choose>
         </td>
     </tr>	 	

     <tr>
        <td colspan = "3" class = "left2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_ACRXAUDTYPE/@DISPLAY_NAME" />:
        </td>
        <td colspan = "2">
           <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_ACRXAUDTYPE" />
        </td>
     </tr>
     <tr>
         <td colspan = "3" class = "left2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_ACCPWRUPDELAY/@DISPLAY_NAME" />:
         </td>
         <td colspan = "2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_ACCPWRUPDELAY" />
         </td>
     </tr>
     <tr>
        <td colspan = "3" class = "left2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_DEBDUR/@DISPLAY_NAME" />:
        </td>
        <td colspan = "2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_DEBDUR" />
        </td>
     </tr>
     <tr>
        <td colspan = "3" class = "left2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_EXTALARMDUR/@DISPLAY_NAME" />:
        </td>
        <td colspan = "2">
           <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_EXTALARMDUR" />
        </td>
     </tr>
     <tr>
        <td colspan = "3" class = "left2">
           <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_EXTALARMDELAY/@DISPLAY_NAME" />:
        </td>
        <td colspan = "2">
           <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_EXTALARMDELAY" />
        </td>
     </tr>
     <tr>
        <td colspan = "3" class = "left2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_DATAPTTOVERRIDEVOICE/@DISPLAY_NAME" />:
        </td>
        <td colspan = "2">
            <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/AC_DATAPTTOVERRIDEVOICE" />
        </td>
     </tr>
	 <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')" >
		<tr>
		   <td colspan = "3" class = "left2">
			  <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/X_AC_PERMEXTALARM/@DISPLAY_NAME" />
		   </td>
		   <td colspan = "2">
			  <xsl:value-of select = "AC_BLOCK/ENTRY_DATA/X_AC_PERMEXTALARM" />
		   </td>
		</tr>
      </xsl:if>
   </xsl:template>

   <xsl:template match = "MDC_BLOCK" >

         <tr>
            <xsl:text disable-output-escaping = "yes">
                  &lt;th> &amp;nbsp &lt;/th>
               </xsl:text>       
            <xsl:apply-templates select = "ENTRY_DATA" mode = "counting_mdc" />   
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/MDC_PRIMARYID/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_PRIMARYID" />
         </tr>
         
         <!--CDDts06746-Sean-->
      	<xsl:variable name = "cpver">
          	<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
      	</xsl:variable>
      
      	<xsl:variable name = "MdcDecodeOne">
         <xsl:if test = "contains($m_ProductLine, 'ELT_Conv') and
		($cpver >= '03.01') and
		('05.00' > $cpver) and
         (contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1987A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2051A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2052A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2053A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2054A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2055A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2056A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2361A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2362A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2363A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2364A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2365A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2366A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2367A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2368A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2369A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2231A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2232A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2234A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2107A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2108A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2109A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2110A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2111A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2112A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2113A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2114A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2420A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2421A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2422A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2423A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2424A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2425A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2426A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2427A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2428A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2429A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2430A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2431A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2432A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2433A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2115A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2116A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2434A') or
                                                                                      
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2107B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2108B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2109B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2110B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2111B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2112B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2113B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2114B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2420B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2421B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2422B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2423B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2424B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2425B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2426B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2427B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2428B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2429B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2430B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2431B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2432B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2433B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2115B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2116B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2434B') or

          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1987B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2051B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2052B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2053B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2054B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2055B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2056B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2361B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2362B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2363B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2364B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2365B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2366B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2367B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2368B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2369B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2231B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2232B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2234B') or
          
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1938A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1945A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1872A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1904B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1876A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1905B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2003A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2158A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE1997A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2090B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2009A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2091B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2145A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2146A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2148A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2014A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2015A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2017A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2092B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2151A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2152A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2154A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2188A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2189A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2045A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2119A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2120A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2121A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2122A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2117A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2118A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2123A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2124A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2435A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2436A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2437A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2438A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2418A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2419A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2439A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2440A') or
          
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2119B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2120B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2121B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2122B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2117B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2118B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2123B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2124B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2435B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2436B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2437B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2438B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2418B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2419B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2439B') or
	  contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2440B') or
	  
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1938B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1945B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1872B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1904C') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1876B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD1905C') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2003B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2158B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE1997B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2090C') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2009B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2091C') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2145B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2146B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2148B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2014B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2015B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2017B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2092C') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2151B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2152B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2154B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2188B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2189B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUD2045B') or

          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2526A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2526B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2527A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2527B') or

          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2522A') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2522B') or
          contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM, 'PMUE2554A') ) 
          ">
         	BMdcDecodeOne
         </xsl:if>
      	</xsl:variable>

	<!-- CDDts09753-Kyle -->
	<xsl:variable name = "MdcDecodeTwo">
      	 <xsl:if test = "contains($m_ProductLine, 'ELT_Conv') and
		($cpver >= '05.00') and 
		contains(/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_EDITMODE, '1') ">
		BMdcDecodeTwo
         </xsl:if>
      	</xsl:variable>

	<xsl:variable name = "MdcDecodeEn">
      	 <xsl:if test = "contains($MdcDecodeOne, 'BMdcDecodeOne') or
      	 	contains($MdcDecodeTwo, 'BMdcDecodeTwo') ">
		BMdcDecodeEn
         </xsl:if>
      	</xsl:variable>

	<xsl:variable name = "CallAlertEn">
	<!-- Added by Alice Wan, CCB410 -->
		<xsl:if test = "(($cpver >= '04.00') and
               		 contains(/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_AOBA, '1') and
         		       (contains(/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_MODELTYPE, 'Marlin+') and 
         		       contains($m_ProductLine, 'ELT_Conv') ) ) or
         		       ($MdcCallAlertDecEnable = 'true')">
        <!-- Added by Alice Wan, CCB410 -->
			BCallAlertEn
		</xsl:if>
	</xsl:variable>

      	<xsl:if test = "contains($MdcDecodeEn,'BMdcDecodeEn') or contains($CallAlertEn,'BCallAlertEn') ">

         		<tr>
            		  <td class = "em">
               		    <xsl:value-of select = "ENTRY_DATA/MDC_GRPID/@DISPLAY_NAME" />
            		  </td>
            		  <xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_GRPID" />
         		</tr>
         </xsl:if>
         
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/MDC_PTTIDTYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_PTTIDTYPE" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/MDC_PTTSIDETONEEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_PTTSIDETONEEN" />
         </tr>         
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/MDC_DOSAUTOMUTEDUR/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_DOSAUTOMUTEDUR" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/MDC_PRETIME/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_PRETIME" />
         </tr>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PNK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
            <tr>
               <td class = "em">
                  <xsl:value-of select = "ENTRY_DATA/MDC_DOSCOASTDUR/@DISPLAY_NAME" />
               </td>
               <xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_DOSCOASTDUR" />
            </tr>
            <tr>
               <td class = "em">
                  <xsl:value-of select = "ENTRY_DATA/MDC_DOSCRITYPE/@DISPLAY_NAME" />
               </td>
               <xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_DOSCRITYPE" />
            </tr>
            <tr>
               <td class = "em">
                  <xsl:value-of select = "ENTRY_DATA/MDC_FIXRETWAITTIME/@DISPLAY_NAME" />
               </td>
               <xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_FIXRETWAITTIME" />
            </tr>
         </xsl:if>

         <!--CDDts06746-Sean-->
      	<xsl:if test = "contains($MdcDecodeEn, 'BMdcDecodeEn')">
         		<tr>
            		<td class = "em">
               		<xsl:value-of select = "ENTRY_DATA/MDC_SELCALDECEN/@DISPLAY_NAME" />
            		</td>
            		<xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_SELCALDECEN" />
         		</tr>

         		<tr>
            		<td class = "em">
               		<xsl:value-of select = "ENTRY_DATA/MDC_SELCALLEDEN/@DISPLAY_NAME" />
            		</td>
            		<xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_SELCALLEDEN" />
         		</tr>

         		<tr>
            		<td class = "em">
               		<xsl:value-of select = "ENTRY_DATA/MDC_AUTORESTIMERTYPE/@DISPLAY_NAME" />
            		</td>
            		<xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_AUTORESTIMERTYPE" />
         		</tr>

         </xsl:if>


         <!--CDDts08487 & CDDts09157-Sean-->      	      
         <xsl:if test = "contains($CallAlertEn,'BCallAlertEn')">

         		<tr>
            		<td class = "em">
               		<xsl:value-of select = "ENTRY_DATA/MDC_CALLALERTTYPE/@DISPLAY_NAME" />
            		</td>
            		<xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_CALLALERTTYPE" />
         		</tr>

         		<tr>
            		<td class = "em">
               		<xsl:value-of select = "ENTRY_DATA/MDC_CALLALERTLEDEN/@DISPLAY_NAME" />
            		</td>
            		<xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_CALLALERTLEDEN" />
         		</tr>

         		<tr>
            		<td class = "em">
               		<xsl:value-of select = "ENTRY_DATA/MDC_ALERTAUTORESEN/@DISPLAY_NAME" />
            		</td>
            		<xsl:apply-templates select = "ENTRY_DATA" mode = "MDC_ALERTAUTORESEN" />
         		</tr>

         </xsl:if>

                     
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_PRETIME">
      <td class = "repeat">
         <xsl:value-of select = "MDC_PRETIME" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "MDC_DOSAUTOMUTEDUR">
      <td class = "repeat">
         <xsl:value-of select = "MDC_DOSAUTOMUTEDUR" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_PRIMARYID">
      <td class = "repeat">
         <xsl:value-of select = "MDC_PRIMARYID" />
      </td>
   </xsl:template>

   <!--CDDts06746-Sean-->
   <xsl:template match = "ENTRY_DATA" mode = "MDC_GRPID">
      <td class = "repeat">
         <xsl:value-of select = "MDC_GRPID" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_SELCALDECEN">
      <td class = "repeat">
         <xsl:value-of select = "MDC_SELCALDECEN" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_SELCALLEDEN">
      <td class = "repeat">
         <xsl:value-of select = "MDC_SELCALLEDEN" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_AUTORESTIMERTYPE">
      <td class = "repeat">
         <xsl:value-of select = "MDC_AUTORESTIMERTYPE" />
      </td>
   </xsl:template>

   <!--CDDts08487-Sean-->
   <xsl:template match = "ENTRY_DATA" mode = "MDC_CALLALERTLEDEN">
      <td class = "repeat">
         <xsl:apply-templates select = "MDC_CALLALERTLEDEN" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_ALERTAUTORESEN">
      <td class = "repeat">
         <xsl:apply-templates select = "MDC_ALERTAUTORESEN" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_CALLALERTTYPE">
      <td class = "repeat">
         <xsl:value-of select = "MDC_CALLALERTTYPE" />
      </td>
   </xsl:template>
   <!--CDDts08487-->

   <xsl:template match = "ENTRY_DATA" mode = "MDC_PTTIDTYPE">
      <td class = "repeat">
         <xsl:value-of select = "MDC_PTTIDTYPE" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_PTTSIDETONEEN">
      <td class = "repeat">
         <xsl:value-of select = "MDC_PTTSIDETONEEN" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_DOSCOASTDUR">
      <td class = "repeat">
         <xsl:value-of select = "MDC_DOSCOASTDUR" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_DOSCRITYPE">
      <td class = "repeat">
         <xsl:value-of select = "MDC_DOSCRITYPE" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "MDC_FIXRETWAITTIME">
      <td class = "repeat">
         <xsl:value-of select = "MDC_FIXRETWAITTIME" />
      </td>
   </xsl:template>

   <xsl:template match = "DTMF_BLOCK" >
      <tr>
           <xsl:text disable-output-escaping = "yes">
               &lt;th> &amp;nbsp &lt;/th>
            </xsl:text>       
         <xsl:apply-templates select = "ENTRY_DATA" mode = "counting_dtmf" />
      </tr>
      <tr>
         <td class = "em">
            <xsl:value-of select = "ENTRY_DATA/DTMF_PRIMARYID/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "DTMF_PRIMARYID" />
      </tr>
      <tr>
         <td class = "em">
            <xsl:value-of select = "ENTRY_DATA/DTMF_GRPID/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "DTMF_GRPID" />
      </tr>
      <tr>
         <td class = "em">
            <xsl:value-of select = "ENTRY_DATA/DTMF_PTTIDTYPE/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "DTMF_PTTIDTYPE" />
      </tr>
      <tr>
         <td class = "em">
            <xsl:value-of select = "ENTRY_DATA/X_DTMF_PTTSIDETONE/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "X_DTMF_PTTSIDETONE" />
      </tr>      
      <tr>
         <td class = "em">
            <xsl:value-of select = "ENTRY_DATA/DTMF_PRETIME/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "DTMF_PRETIME" />
      </tr>
      <tr>
        <td class = "em">
           <xsl:value-of select = "ENTRY_DATA/DTMF_TXTONEDUR/@DISPLAY_NAME" />
        </td>
        <xsl:apply-templates select = "ENTRY_DATA" mode = "DTMF_TXTONEDUR" />
     </tr>
      <tr>
        <td class = "em">
           <xsl:value-of select = "ENTRY_DATA/DTMF_TXTONEINTERVAL/@DISPLAY_NAME" />
        </td>
        <xsl:apply-templates select = "ENTRY_DATA" mode = "DTMF_TXTONEINTERVAL" />
     </tr>	        
      <xsl:if test = "contains(../RC_BLOCK/ENTRY_DATA/X_MODEL, 'PNK') or
		             contains(../RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
						 contains(../RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
						 contains(../RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') ">
      <!-- DTMF Call Type -->
		  <tr>
			 <td class = "em">
				<xsl:value-of select = "ENTRY_DATA/X_DTMF_CALLTYPE/@DISPLAY_NAME" />
			 </td>
			 <xsl:apply-templates select = "ENTRY_DATA" mode = "X_DTMF_CALLTYPE" />
		  </tr>
         <!-- Call LED -->
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_DTMF_CALLLED/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "X_DTMF_CALLLED" />
         </tr>
         <!-- DTMF Alert Tone Auto Reset -->
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/DTMF_ALERTAUTORESEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "DTMF_ALERTAUTORESEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/DTMF_AUTORESTIMERTYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "DTMF_AUTORESTIMERTYPE" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/DTMF_ACKTYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "DTMF_ACKTYPE" />
         </tr>
          <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/DTMF_RESETDUR/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "DTMF_RESETDUR" />
         </tr>
      </xsl:if>	      
   </xsl:template>
   
   <xsl:template match = "QC_BLOCK" >
         <tr>
               <xsl:text disable-output-escaping = "yes">
                  &lt;th> &amp;nbsp &lt;/th>
               </xsl:text>       
            <xsl:apply-templates select = "ENTRY_DATA" mode = "counting_qc" />   
         </tr>

         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_QC_CALLTYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "X_QC_CALLTYPE" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_QC_CALLLED/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "X_QC_CALLLED" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QC_ALERTAUTORESEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "QC_ALERTAUTORESEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QC_AUTORESTIMERTYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "QC_AUTORESTIMERTYPE" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QC_CALLFORMAT/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "QC_CALLFORMAT" />
         </tr>
         
		 <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
		                 contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') or
						 contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK')" >
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QC_PRETIME/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "QC_PRETIME" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QC_LONGTONEDUR/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "QC_LONGTONEDUR" />
         </tr>
		 </xsl:if>
		 		 
		 <tr>
            <td class = "em">
               ^0407^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "QC_INDIDTONEA" />
         </tr>
         <tr>
            <td class = "em">
               ^0408^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "QC_INDIDTONEB" />
         </tr>
         <tr>
            <td class = "em">
               ^0409^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "QC_INDIDTONEC" />
         </tr>
         <tr>
            <td class = "em">
               ^0410^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "QC_INDIDTONED" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_QC_CODEA/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "X_QC_CODEA" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_QC_CODEB/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "X_QC_CODEB" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_QC_CODEC/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "X_QC_CODEC" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_QC_CODED/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "X_QC_CODED" />
         </tr>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') ">
            <tr>
               <td class = "em">
                  <xsl:value-of select = "ENTRY_DATA/QC_PTTSIDETONEEN/@DISPLAY_NAME" />
               </td>
               <xsl:apply-templates select = "ENTRY_DATA" mode = "QC_PTTSIDETONEEN" />
            </tr>
         </xsl:if>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "QC_PTTSIDETONEEN">
      <td class = "repeat">
         <xsl:value-of select = "QC_PTTSIDETONEEN" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "QC_ALERTAUTORESEN">
      <td class = "repeat">
         <xsl:apply-templates select = "QC_ALERTAUTORESEN" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "QC_CALLALERTLEDEN">
      <td class = "repeat">
         <xsl:apply-templates select = "QC_CALLALERTLEDEN" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "X_QC_CALLTYPE">
      <td class = "repeat">
         <xsl:value-of select = "X_QC_CALLTYPE" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "X_QC_CALLLED">
      <td class = "repeat">
         <xsl:value-of select = "X_QC_CALLLED" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "QC_AUTORESTIMERTYPE">
      <td class = "repeat">
         <xsl:value-of select = "QC_AUTORESTIMERTYPE" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "QC_CALLFORMAT">
      <td class = "repeat">
         <xsl:apply-templates select = "QC_CALLFORMAT" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "QC_INDIDTONEA">
      <td class = "repeat">
         <xsl:apply-templates select = "QC_INDIDTONEA" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "QC_INDIDTONEB">
      <td class = "repeat">
         <xsl:apply-templates select = "QC_INDIDTONEB" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "QC_INDIDTONEC">
      <td class = "repeat">
         <xsl:apply-templates select = "QC_INDIDTONEC" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "QC_INDIDTONED">
      <td class = "repeat">
         <xsl:apply-templates select = "QC_INDIDTONED" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "X_QC_CODEA">
      <td class = "repeat">
         <xsl:value-of select = "X_QC_CODEA" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "X_QC_CODEB">
      <td class = "repeat">
         <xsl:value-of select = "X_QC_CODEB" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "X_QC_CODEC">
      <td class = "repeat">
         <xsl:value-of select = "X_QC_CODEC" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "X_QC_CODED">
      <td class = "repeat">
         <xsl:value-of select = "X_QC_CODED" />
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "counting_qc">
      <th>
	   <xsl:if test = "ALIAS != ''"> 
	      <xsl:apply-templates select = "ALIAS"/>
         </xsl:if>
	   <xsl:if test = "ALIAS = ''"> 
	      ^0328^
		<xsl:value-of select = "position()" />
	   </xsl:if>
      </th>
   </xsl:template>
      <xsl:template match = "ENTRY_DATA" mode = "counting_dtmf">
      <th>
	   <xsl:if test = "ALIAS != ''"> 
	      <xsl:apply-templates select = "ALIAS"/>
         </xsl:if>
	   <xsl:if test = "ALIAS = ''"> 
	      ^0328^
		<xsl:value-of select = "position()" />
	   </xsl:if>
      </th>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "counting_mdc">
      <th>
	   <xsl:if test = "ALIAS != ''"> 
	      <xsl:apply-templates select = "ALIAS"/>
         </xsl:if>
	   <xsl:if test = "ALIAS = ''"> 
	      ^0328^
		<xsl:value-of select = "position()" />
	   </xsl:if>
      </th>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "counting_ps">
      <th>
	   <xsl:if test = "ALIAS != ''"> 
	      <xsl:apply-templates select = "ALIAS"/>
         </xsl:if>
	   <xsl:if test = "ALIAS = ''"> 
	      ^0328^
		<xsl:value-of select = "position()" />
	   </xsl:if>
      </th>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "counting_qcc">
      <th>
	   <xsl:if test = "ALIAS != ''"> 
	      <xsl:apply-templates select = "ALIAS"/>
         </xsl:if>
	   <xsl:if test = "ALIAS = ''"> 
	      ^0427^
		<xsl:value-of select = "position()" />
	   </xsl:if>
      </th>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "counting_space">
      <td />
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "N_ALIAS">
      <th>
         <xsl:apply-templates select = "ALIAS" />
      </th>
   </xsl:template>


   <xsl:template match="RI_SERIALNUM">
      <tr>
         <td class = "em">
            <xsl:value-of select = "@DISPLAY_NAME"/>
         </td>
         <td>
            <xsl:value-of select="." /> 
         </td> 
      </tr>
   </xsl:template>

   <xsl:template match="RI_MODELNUM">
      <tr>
         <td class = "em">
            <xsl:value-of select = "@DISPLAY_NAME"/>
         </td>
         <td>
            <xsl:value-of select="." />
         </td>
      </tr>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "counting_space">
      <td />
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "CP_PHSYSINDEX">
      <td>
         <xsl:if test = "contains(CP_PHSYSINDEX, '^0602^')">
            <xsl:value-of select = "CP_PHSYSINDEX" />
         </xsl:if>
		 
		 <xsl:if test = "not(contains(CP_PHSYSINDEX, '^0602^'))">
         	<xsl:variable name = "index2">
			   <xsl:value-of select = "CP_PHSYSINDEX" />
			</xsl:variable> 
            <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/PS_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" />
         </xsl:if>
      </td>         
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_ALIAS">
      <th>
         <xsl:apply-templates select = "ALIAS" />
      </th>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "X_CP_CHNNELPOSITION">
       <xsl:param name = 'start'/>
       <td>
               <xsl:variable name = 'index' select = 'position() -1+$start -1' />
               <xsl:variable name = 'type'>Conventional</xsl:variable>
               <xsl:apply-templates select = '/ELP_ELM_CODEPLUG/RRW/PA_BLOCK/LIST_DATA/ENTRY_DATA[PA_PERSTYPE = $type and PA_PERSINDEX = $index]' mode = 'channel_position'/>
       </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_OPTBRDFEATEN">
      <td>
         <xsl:value-of select = "CP_OPTBRDFEATEN" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_FLATTXAUDIOEN">
      <td>
         <xsl:value-of select = "CP_FLATTXAUDIOEN" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_OPTBRDCONFIGINDEX">
	  <td>
         <xsl:value-of select = "CP_OPTBRDCONFIGINDEX" />
      </td>
   </xsl:template>
   
   
   <xsl:template match="ENTRY_DATA" mode = "CP_CHBWSEL">
      <td>
         <xsl:apply-templates select = "CP_CHBWSEL" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXONLY">
	  <td>
         <xsl:value-of select = "X_CP_RXONLY" />
      </td>
   </xsl:template>
   
   <!-- Added by Alice Wan, CCB410 -->
   <!-- Added by Alice Wan, CCB410 2010-6-7 -->
   <xsl:template match="ENTRY_DATA" mode = "CP_ARTSEN">
      <td>      
         <xsl:choose>
            <xsl:when test = "CP_RXSQCODESEL = '^0614^' 
                           or CP_TXSQCODESEL = '^0614^'">
               ^0316^
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select = "CP_ARTSEN" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>
   <!-- Added by Alice Wan, CCB410 2010-6-7 -->
   
   <xsl:template match="ENTRY_DATA" mode = "CP_LONEWOKEREN">
      <td>
         <xsl:value-of select = "CP_LONEWOKEREN" />
      </td>
   </xsl:template>
   <!-- Added by Alice Wan, CCB410 -->

   <xsl:template match="ENTRY_DATA" mode = "CP_RXFREQ">
	  <td>
         <xsl:apply-templates select = "CP_RXFREQ" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXSQCODESEL">
	  <td>
         <xsl:apply-templates select = "CP_RXSQCODESEL" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXSQCODESEL">
	  <td>
         <xsl:value-of select = "CP_TXSQCODESEL" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXDECDATA_DPL">
	  <td>
         <xsl:if test = "CP_RXSQCODESEL = '^0612^'">
            <xsl:value-of select = "CP_RXDECDATA" />
         </xsl:if>
         <xsl:if test = "CP_RXSQCODESEL != '^0612^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXDECDATA_TPL">
	  <td>
         <xsl:if test = "CP_RXSQCODESEL = '^0613^'">
            <xsl:value-of select = "CP_RXDECDATA" />
         </xsl:if>
         <xsl:if test = "CP_RXSQCODESEL != '^0613^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXDPLINVERT">
	  <td>
         <xsl:choose>
            <xsl:when test = "CP_RXSQCODESEL = '^0612^'">
               <xsl:value-of select = "CP_RXDPLINVERT" />
            </xsl:when>
            <xsl:otherwise>
               ^0316^
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXFREQ">
	  <td>
         <xsl:apply-templates select = "CP_TXFREQ" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXSQCODESEL">
	  <td>
         <xsl:apply-templates select = "CP_RXSQCODESEL" />
      </td>
   </xsl:template>


   <xsl:template match="ENTRY_DATA" mode = "CP_TXENCDATA_DPL">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0612^'">
            <xsl:value-of select = "CP_TXENCDATA" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0612^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXENCDATA_TPL">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0613^'">
            <xsl:value-of select = "CP_TXENCDATA" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0613^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "X_CP_REVBURST">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0613^'">
            <xsl:value-of select = "X_CP_REVBURST" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0613^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXDPLINVERT">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0612^'">
            <xsl:value-of select = "CP_TXDPLINVERT" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0612^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TALKAROUNDEN">
	  <td>
         <xsl:value-of select = "CP_TALKAROUNDEN" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_VOXEN">
	  <td>
         <xsl:value-of select = "CP_VOXEN" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXPWRLEVSEL">
	  <td>
         <xsl:apply-templates select = "CP_TXPWRLEVSEL" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TOT">
	  <td>
         <xsl:apply-templates select = "CP_TOT" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TOTTYPE">
	  <td>
         <xsl:value-of select = "CP_TOTTYPE" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RESETDURINHDUR">
	  <td>
         <xsl:value-of select = "CP_RESETDURINHDUR" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_SQSET">
	  <td>
         <xsl:apply-templates select = "CP_SQSET" />
      </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "X_CP_WHISPER">
	  <td>
         <xsl:value-of select = "X_CP_WHISPER" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_CARRIERTIMERDUR">
	  <td>
         <xsl:apply-templates select = "CP_CARRIERTIMERDUR" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_UNMUTETYPE">
	  <td>
         <xsl:if test = "CP_RXSQCODESEL != '^0614^'">
            <xsl:value-of select = "CP_UNMUTETYPE" />
         </xsl:if>
         <xsl:if test = "CP_RXSQCODESEL = '^0614^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_BUSYCHLKOUT">
	  <td>
         <xsl:apply-templates select = "CP_BUSYCHLKOUT" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXSIGTYPE">
	  <td>
         <xsl:value-of select = "CP_RXSIGTYPE" />
	   <xsl:text disable-output-escaping = "yes">
		&amp;nbsp;
	   </xsl:text>
	   <xsl:variable name = "index2">
	 	<xsl:value-of select = "CP_RXSIGINDEX" />
	   </xsl:variable>
	   <xsl:if test = "CP_RXSIGTYPE = '^0625^'">
	     <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/QC_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_RXSIGTYPE = '^0616^'">
	     <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/MDC_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_RXSIGTYPE = '^0624^'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/DTMF_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_RXSIGTYPE = 'ATIS'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/ATIS_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_RXSIGTYPE = 'SDT'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/SDT_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_RXSIGTYPE = 'None'">
	     ^0327^
	   </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_PLREQFORDATA">
	  <td>
         <xsl:choose>
            <xsl:when test = "CP_RXSIGTYPE = 'None'">
               ^0316^
            </xsl:when>
            <xsl:when test = "CP_RXSIGTYPE != 'None' and 
                               CP_RXSQCODESEL = '^0614^'" >
               ^0316^
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select = "CP_PLREQFORDATA" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_SIGSQ">
	  <td>
         <xsl:choose>
            <xsl:when test = "CP_RXSIGTYPE = 'None'">
               ^0316^
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates select = "CP_SIGSQ" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXSIGTYPE">
	  <td>
         <xsl:value-of select = "CP_TXSIGTYPE" />
	   <xsl:text disable-output-escaping = "yes">
		   &amp;nbsp;
	   </xsl:text>
	   <xsl:variable name = "index2">
	 	   <xsl:value-of select = "CP_TXSIGINDEX" />
	   </xsl:variable>
	   <xsl:if test = "CP_TXSIGTYPE = '^0625^'">
	     <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/QC_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_TXSIGTYPE = '^0616^'">
	     <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/MDC_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_TXSIGTYPE = '^0624^'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/DTMF_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_TXSIGTYPE = 'ATIS'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/ATIS_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_TXSIGTYPE = 'SDT'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/SDT_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_TXSIGTYPE = 'None'">
	     ^0327^
	   </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_SCANLISTINDEX">
	  <td>
         <xsl:apply-templates select = "CP_SCANLISTINDEX" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_AUTOSCANEN">
	  <td>
         <xsl:value-of select = "CP_AUTOSCANEN" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "X_CP_COMPANDING">
	  <td>
         <xsl:apply-templates select = "X_CP_COMPANDING" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_EXPTYPE">
	  <td>
         <xsl:apply-templates select = "CP_EXPTYPE" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_EMPSEL">
	  <td>
         <xsl:apply-templates select = "CP_EMPSEL" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXREFFREQ">
	  <td>
         <xsl:apply-templates select = "CP_RXREFFREQ" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXREFFREQ">
      <td>
         <xsl:apply-templates select = "CP_TXREFFREQ" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "X_CP_RX_TPL_CODE">
	  <td>
         <xsl:if test = "CP_RXSQCODESEL = '^0613^'">
            <xsl:value-of select = "X_CP_RX_TPL_CODE" />
         </xsl:if>
         <xsl:if test = "CP_RXSQCODESEL != '^0613^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_DATAREVERTPERINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "CP_DATAREVERTPERINDEX" />
      </xsl:variable>
      <xsl:variable name = "con_type">Conventional</xsl:variable>
      <xsl:variable name = "lty_type">LS Trunking</xsl:variable>
      <xsl:choose>
          <xsl:when test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR != 1">
              <td><xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
          </xsl:when> 
          <xsl:when test = "$con_type = CP_DATAREVERTPERTYPE">
              <td>CNV <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
          </xsl:when>
          <xsl:when test = "$lty_type = CP_DATAREVERTPERTYPE">
              <td>LTR <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
          </xsl:when>
      </xsl:choose>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "X_CP_TX_TPL_CODE">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0613^'">
            <xsl:value-of select = "X_CP_TX_TPL_CODE" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0613^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "TX_DPL_TURNOFF_CODE">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0612^'">
            <xsl:value-of select = "CP_TOCEN" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0612^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ALIAS">
      <xsl:variable name = "oldAlias">
         <xsl:value-of select="." />
      </xsl:variable>
      <xsl:call-template name = "aliastransform">
         <xsl:with-param name = "aliasname1">
            <xsl:value-of select = "$oldAlias" />
         </xsl:with-param>
      </xsl:call-template>
   </xsl:template>

   <xsl:template match="CP_CHBWSEL">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_RXFREQ">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_RXSQCODESEL">
      <xsl:value-of select="." /> 
   </xsl:template>      
      
   <xsl:template match="CP_TXFREQ">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_TXENCDATA">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_REVBURSTTOCEN">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_TXPWRLEVSEL">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_TOT">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_SQSET">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_UNMUTETYPE">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_BUSYCHLKOUT">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_RXSIGTYPE">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_TXSIGTYPE">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_SCANLISTINDEX">
      <xsl:variable name = "index">
         <xsl:value-of select = "./text()" />
      </xsl:variable>
      <xsl:choose>
         <xsl:when test = "$index = '255'">
            ^0327^
         </xsl:when>
         <xsl:when test = "$index != '255'">
	    <xsl:apply-templates select = "../../../SLI_BLOCK/LIST_DATA[position() = ($index +1)]/ENTRY_INFO/ALIAS" />
         </xsl:when>
      </xsl:choose>
   </xsl:template>
   
   <xsl:template match = "ENTRY_INFO" mode = "sli">
      a<xsl:value-of select = "position()" />a
      <xsl:apply-templates select = "ALIAS" />
   </xsl:template>
      
   <xsl:template match="CP_AUTOSCANEN">
      <xsl:value-of select="." /> 
   </xsl:template>
   
   <!-- PCCB1-Alice -->
   <xsl:template match="CP_FLATTXAUDIOEN">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="X_CP_COMPANDING">
      <xsl:value-of select="." /> 
   </xsl:template>
   
   <!-- Added by Alice Wan, CCB410 -->
   <xsl:template match="CP_ARTSEN">
      <xsl:value-of select="." /> 
   </xsl:template>
   
   <xsl:template match="CP_LONEWOKEREN">
      <xsl:value-of select="." /> 
   </xsl:template>
   <!-- Added by Alice Wan, CCB410 -->
      
   <xsl:template match="CP_EXPTYPE">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_EMPSEL">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_RXREFFREQ">
      <xsl:value-of select="." /> 
   </xsl:template>
   
   <xsl:template match="CP_TXREFFREQ">
      <xsl:value-of select="." /> 
   </xsl:template>
   
   <xsl:template match = "PN_BLOCK">
      <table class = "nonrepeat">
         <th>
            <td>^0424^</td>
            <td>^0422^</td>
            <td>^0425^</td>
         </th>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "phone_list" />
      </table>
   </xsl:template>
   
   <xsl:template match = "ENTRY_DATA" mode = "phone_list">
      <xsl:if test = "position() &gt;= 2" >
      <tr>
         <td />
         <td>
            <xsl:value-of select = "position() - 1" />
         </td>
         <td>
            <xsl:apply-templates select = "ALIAS" />
         </td>
         <td>
            <xsl:value-of select = "PHN_NUM" />
         </td>
      </tr>
      </xsl:if>
   </xsl:template>

   <xsl:template match = "PS_BLOCK">
      <table>
         <tr>
            <xsl:text disable-output-escaping = "yes">
                  &lt;th> &amp;nbsp &lt;/th>
               </xsl:text>       
            <xsl:apply-templates select = "ENTRY_DATA" mode = "counting_ps" />   
         </tr>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
            <tr>
               <td class = "em">
                  <xsl:value-of select = "ENTRY_DATA/PS_DIALTYPE/@DISPLAY_NAME" />
               </td>
               <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_DIALTYPE" />
            </tr>
         </xsl:if>        
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_ACCESSCODE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_ACCESSCODE" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_DEACCESSCODE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_DEACCESSCODE" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_ACCDEACCTYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_ACCDEACCTYPE" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_PHNOVERRIDEBCLEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_PHNOVERRIDEBCLEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_DEACCBACKPORCHDELAY/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_DEACCBACKPORCHDELAY" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_PLREQEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_PLREQEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_STRIPPLPHNMODE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_STRIPPLPHNMODE" />
         </tr>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">         
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_TONESPAN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_TONESPAN" />
         </tr>
	 </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_PTTSIDETONEEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_PTTSIDETONEEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_MUTEACCDEACCEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_MUTEACCDEACCEN" />
         </tr>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_TXHANGTIME/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_TXHANGTIME" />
         </tr>
	 </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_PAUSEDUR/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_PAUSEDUR" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_PRETIME/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_PRETIME" />
         </tr>         
	 <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_TXTONEDUR/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_TXTONEDUR" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/PS_TXTONEINTERVAL/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_TXTONEINTERVAL" />
         </tr> 
         <xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR = 1">
            <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') ">
                <tr>
                    <td class = "em">
                        <xsl:value-of select = "ENTRY_DATA/PS_INTCONNRVTPERSINDEX/@DISPLAY_NAME" />
                    </td>
                    <xsl:apply-templates select = "ENTRY_DATA" mode = "PS_INTCONNRVTPERSINDEX" />
                </tr> 
            </xsl:if>
         </xsl:if>
      </table>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "PS_DIALTYPE">
      <td>
         <xsl:value-of select = "PS_DIALTYPE" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_ACCESSCODE">
      <td>
         <xsl:value-of select = "PS_ACCESSCODE" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_DEACCESSCODE">
      <td>
         <xsl:value-of select = "PS_DEACCESSCODE" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_ACCDEACCTYPE">
      <td>
         <xsl:value-of select = "PS_ACCDEACCTYPE" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_PHNOVERRIDEBCLEN">
      <td>
         <xsl:value-of select = "PS_PHNOVERRIDEBCLEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_DEACCBACKPORCHDELAY">
      <td>
         <xsl:value-of select = "PS_DEACCBACKPORCHDELAY" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_PLREQEN">
      <td>
         <xsl:value-of select = "PS_PLREQEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_STRIPPLPHNMODE">
      <td>
         <xsl:value-of select = "PS_STRIPPLPHNMODE" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_TONESPAN">
      <td>
         <xsl:value-of select = "PS_TONESPAN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_PTTSIDETONEEN">
      <td>
         <xsl:value-of select = "PS_PTTSIDETONEEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_MUTEACCDEACCEN">
      <td>
         <xsl:value-of select = "PS_MUTEACCDEACCEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_TXHANGTIME">
      <td>
         <xsl:value-of select = "PS_TXHANGTIME" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_PAUSEDUR">
      <td>
         <xsl:value-of select = "PS_PAUSEDUR" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_PRETIME">
      <td>
         <xsl:value-of select = "PS_PRETIME" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_TXTONEDUR">
      <td>
         <xsl:value-of select = "PS_TXTONEDUR" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_TXTONEINTERVAL">
      <td>
         <xsl:value-of select = "PS_TXTONEINTERVAL" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "PS_INTCONNRVTPERSINDEX">
      <td>
          <xsl:choose> 
              <xsl:when test = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_INFO/ENTRY_QUANTITY = '0'">
                  ^0316^
              </xsl:when>
              <xsl:when test = "PS_INTCONNRVTPERSINDEX = '255'">
                  Selected
              </xsl:when>
              <xsl:otherwise>
                  <xsl:variable name = "index">
                       <xsl:value-of select = "PS_INTCONNRVTPERSINDEX" />
                  </xsl:variable>
                  <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA[position() = ($index+1)]/ALIAS"/>
              </xsl:otherwise>
          </xsl:choose>
      </td>
   </xsl:template>

   <xsl:template match = "CALL_BLOCK">
      <table class = "nonrepeat">
         <th>
            <td>^0424^</td>
            <td>^0422^</td>
            <td>^0423^</td>
         </th>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "CALL_BLOCK" />
      </table>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "CALL_BLOCK">
      <tr>
         <td />
         <td>
            <xsl:value-of select = "position()" />
         </td>
         <td>
            <xsl:if test = "contains(CL_SIGNALINGTYPE, 'Quik-Call II')" >
               <xsl:variable name = "index">
                  <xsl:value-of select = "CL_SIGNALINGINDEX" />
               </xsl:variable>
               <xsl:apply-templates select = "../../QCC_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS" />
            </xsl:if>
            <xsl:if test = "contains(CL_SIGNALINGTYPE, 'DTMF') ">
               <xsl:variable name = "index">
                  <xsl:value-of select = "CL_SIGNALINGINDEX" />
               </xsl:variable>
               <xsl:apply-templates select = "../../DTMFC_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS" />
            </xsl:if>
            
            <!--CDDts06746-Sean-->
            <xsl:if test = "contains(CL_SIGNALINGTYPE, 'MDC') ">
               <xsl:variable name = "index">
                  <xsl:value-of select = "CL_SIGNALINGINDEX" />
               </xsl:variable>
               <xsl:apply-templates select = "../../MDCC_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS" />
            </xsl:if>

            
         </td>
         <td>
            <xsl:value-of select = "CL_SIGNALINGTYPE" />
         </td>
      </tr>
   </xsl:template>

   <xsl:template match = "QCC_BLOCK">
      <xsl:variable name = "start">1</xsl:variable>
      <xsl:variable name = "end">
         <xsl:value-of select = "count(ENTRY_DATA)" />
      </xsl:variable>
      <xsl:variable name = "cycle">
         <xsl:value-of select = "ceiling(  count(ENTRY_DATA) div 8  )" />
      </xsl:variable>

      <xsl:if test = "$cycle &gt;= 1">
         <h3> ^0416^ </h3>
            <xsl:call-template name = "QCC_TABLE">
                <xsl:with-param name = "startIndex">0</xsl:with-param>
                <xsl:with-param name = "endIndex">8</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 2">
         <h3> ^0416^ </h3>
            <xsl:call-template name = "QCC_TABLE">
                <xsl:with-param name = "startIndex">9</xsl:with-param>
                <xsl:with-param name = "endIndex">16</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 3">
         <h3> ^0416^ </h3>
            <xsl:call-template name = "QCC_TABLE">
                <xsl:with-param name = "startIndex">17</xsl:with-param>
                <xsl:with-param name = "endIndex">24</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 4">
         <h3> ^0416^ </h3>
            <xsl:call-template name = "QCC_TABLE">
                <xsl:with-param name = "startIndex">25</xsl:with-param>
                <xsl:with-param name = "endIndex">32</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
   </xsl:template>

   <xsl:template name = "QCC_TABLE" >
      <xsl:param name = "startIndex">1</xsl:param>
      <xsl:param name = "endIndex">8</xsl:param>
      <xsl:param name = "break">no</xsl:param>
      <xsl:if test = "$break = 'no'">
         <xsl:text disable-output-escaping = "yes">
            &lt;table>
         </xsl:text>
      </xsl:if>
      <xsl:if test = "$break = 'yes'">
         <xsl:text disable-output-escaping = "yes">
            &lt;table class = "solo">
         </xsl:text>
      </xsl:if>
      <tr>
         <xsl:text disable-output-escaping = "yes">
            &lt;th> &amp;nbsp &lt;/th>
         </xsl:text>       
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "N_ALIAS" />
      </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QCC_QCSYSINDEX/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "QCC_QCSYSINDEX" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QCC_RVTPERSINDEX/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "QCC_RVTPERSINDEX" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QCC_STRIPPLDPLEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "QCC_STRIPPLDPLEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QCC_CALLFORMAT/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "QCC_CALLFORMAT" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QCC_FREQA/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "QCC_FREQA" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/QCC_FREQB/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "QCC_FREQB" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_QCC_CODEA/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_QCC_CODEA" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_QCC_CODEB/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_QCC_CODEB" />
         </tr>
         <xsl:text disable-output-escaping = "yes">
            &lt;table>
         </xsl:text>
         <br />
   </xsl:template>
   
   <xsl:template match = "ENTRY_DATA" mode = "QCC_QCSYSINDEX">
      <td>
         <xsl:variable name = "index">
            <xsl:value-of select = "QCC_QCSYSINDEX" />
         </xsl:variable>
         <xsl:apply-templates select = "../../QC_BLOCK/ENTRY_DATA[position() = ($index + 1)]/ALIAS" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "QCC_RVTPERSINDEX">
      <td>
         <xsl:variable name = "index">
            <xsl:value-of select = "QCC_RVTPERSINDEX" />
         </xsl:variable>
         <xsl:choose>
            <xsl:when test = "$index = '255'">
               Selected
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates select = "../../CP_BLOCK/ENTRY_DATA[position() = ($index + 1)]/ALIAS" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "QCC_STRIPPLDPLEN">
      <td>
         <xsl:value-of select = "QCC_STRIPPLDPLEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "QCC_CALLFORMAT">
      <td>
         <xsl:value-of select = "QCC_CALLFORMAT" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "QCC_FREQA">
      <td>
         <xsl:value-of select = "QCC_FREQA" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "QCC_FREQB">
      <td>
         <xsl:value-of select = "QCC_FREQB" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "X_QCC_CODEA">
      <td>
         <xsl:value-of select = "X_QCC_CODEA" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "X_QCC_CODEB">
      <td>
         <xsl:value-of select = "X_QCC_CODEB" />
      </td>
   </xsl:template>      

   <xsl:template match = "DTMFC_BLOCK">
      <xsl:variable name = "start">1</xsl:variable>
      <xsl:variable name = "end">
         <xsl:value-of select = "count(ENTRY_DATA)" />
      </xsl:variable>
      <xsl:variable name = "cycle">
         <xsl:value-of select = "ceiling(  count(ENTRY_DATA) div 8  )" />
      </xsl:variable>

      <xsl:if test = "$cycle &gt;= 1">
         <h3> ^0447^ </h3>
            <xsl:call-template name = "DTMFC_TABLE">
                <xsl:with-param name = "startIndex">0</xsl:with-param>
                <xsl:with-param name = "endIndex">8</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 2">
         <h3> ^0447^ </h3>
            <xsl:call-template name = "DTMFC_TABLE">
                <xsl:with-param name = "startIndex">9</xsl:with-param>
                <xsl:with-param name = "endIndex">16</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 3">
         <h3> ^0447^ </h3>
            <xsl:call-template name = "DTMFC_TABLE">
                <xsl:with-param name = "startIndex">17</xsl:with-param>
                <xsl:with-param name = "endIndex">24</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 4">
         <h3> ^0447^ </h3>
            <xsl:call-template name = "DTMFC_TABLE">
                <xsl:with-param name = "startIndex">25</xsl:with-param>
                <xsl:with-param name = "endIndex">32</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
   </xsl:template>

   <xsl:template name = "DTMFC_TABLE" >
      <xsl:param name = "startIndex">1</xsl:param>
      <xsl:param name = "endIndex">8</xsl:param>
      <xsl:param name = "break">no</xsl:param>
      <xsl:if test = "$break = 'no'">
         <xsl:text disable-output-escaping = "yes">
            &lt;table>
         </xsl:text>
      </xsl:if>
      <xsl:if test = "$break = 'yes'">
         <xsl:text disable-output-escaping = "yes">
            &lt;table class = "solo">
         </xsl:text>
      </xsl:if>

	  <tr>
         <xsl:text disable-output-escaping = "yes">
            &lt;th> &amp;nbsp &lt;/th>
         </xsl:text>       
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "N_ALIAS" />
      </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/DTMFC_DTMFSYSINDEX/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "DTMFC_DTMFSYSINDEX" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/DTMFC_RVTPERSINDEX/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "DTMFC_RVTPERSINDEX" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/DTMFC_STRIPPLDPLEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "DTMFC_STRIPPLDPLEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/DTMFC_CALLID/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "DTMFC_CALLID" />
         </tr>
         <xsl:text disable-output-escaping = "yes">
            &lt;table>
         </xsl:text>
         <br />
   </xsl:template>
   
   <xsl:template match = "ENTRY_DATA" mode = "DTMFC_DTMFSYSINDEX">
      <td>
         <xsl:variable name = "index">
            <xsl:value-of select = "DTMFC_DTMFSYSINDEX" />
         </xsl:variable>
         <xsl:apply-templates select = "../../DTMF_BLOCK/ENTRY_DATA[position() = ($index + 1)]/ALIAS" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "DTMFC_RVTPERSINDEX">
      <td>
         <xsl:variable name = "index">
            <xsl:value-of select = "DTMFC_RVTPERSINDEX" />
         </xsl:variable>
         <xsl:choose>
            <xsl:when test = "$index = '255'">
               Selected
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates select = "../../CP_BLOCK/ENTRY_DATA[position() = ($index + 1)]/ALIAS" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "DTMFC_STRIPPLDPLEN">
      <td>
         <xsl:value-of select = "DTMFC_STRIPPLDPLEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "DTMFC_CALLID">
      <td>
         <xsl:value-of select = "DTMFC_CALLID" />
      </td>
   </xsl:template>

<!--CDDts06746-Sean-->
   <xsl:template match = "MDCC_BLOCK">
      <xsl:variable name = "start">1</xsl:variable>
      <xsl:variable name = "end">
         <xsl:value-of select = "count(ENTRY_DATA)" />
      </xsl:variable>
      <xsl:variable name = "cycle">
         <xsl:value-of select = "ceiling(  count(ENTRY_DATA) div 8  )" />
      </xsl:variable>

      <xsl:if test = "$cycle &gt;= 1">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">0</xsl:with-param>
                <xsl:with-param name = "endIndex">8</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 2">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">9</xsl:with-param>
                <xsl:with-param name = "endIndex">16</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 3">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">17</xsl:with-param>
                <xsl:with-param name = "endIndex">24</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 4">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">25</xsl:with-param>
                <xsl:with-param name = "endIndex">32</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 5">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">33</xsl:with-param>
                <xsl:with-param name = "endIndex">40</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 6">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">41</xsl:with-param>
                <xsl:with-param name = "endIndex">48</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 7">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">49</xsl:with-param>
                <xsl:with-param name = "endIndex">56</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 8">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">57</xsl:with-param>
                <xsl:with-param name = "endIndex">64</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 9">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">65</xsl:with-param>
                <xsl:with-param name = "endIndex">72</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 10">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">73</xsl:with-param>
                <xsl:with-param name = "endIndex">80</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 11">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">81</xsl:with-param>
                <xsl:with-param name = "endIndex">88</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
      <xsl:if test = "$cycle &gt;= 12">
         <h3> ^3256^ </h3>
            <xsl:call-template name = "MDCC_TABLE">
                <xsl:with-param name = "startIndex">89</xsl:with-param>
                <xsl:with-param name = "endIndex">96</xsl:with-param>
                 <xsl:with-param name = "break">no</xsl:with-param>
            </xsl:call-template>
      </xsl:if>
   </xsl:template>

   <xsl:template name = "MDCC_TABLE" >
      <xsl:param name = "startIndex">1</xsl:param>
      <xsl:param name = "endIndex">8</xsl:param>
      <xsl:param name = "break">no</xsl:param>
      <xsl:if test = "$break = 'no'">
         <xsl:text disable-output-escaping = "yes">
            &lt;table>
         </xsl:text>
      </xsl:if>
      <xsl:if test = "$break = 'yes'">
         <xsl:text disable-output-escaping = "yes">
            &lt;table class = "solo">
         </xsl:text>
      </xsl:if>

	  <tr>
         <xsl:text disable-output-escaping = "yes">
            &lt;th> &amp;nbsp &lt;/th>
         </xsl:text>       
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "N_ALIAS" />
      </tr>
	   
	   <!-- Updated for CCB410 by Yuek -->
	   <!-- Added by Yuek for CCB410 -->
	   <xsl:variable name = "MDFToneTaggingFlag">
		   <xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_TONGTAGGING"/>
	   </xsl:variable>

	   <xsl:variable name ="ToneTaggingEnable">
		   <xsl:value-of select="($cpver >= '09.00') and contains($m_ProductLine, 'ELT_Conv') and ($MDFToneTaggingFlag = '1')"/>
	   </xsl:variable>

	   <xsl:variable name = "DisplayType">
		   <xsl:value-of select="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_DISPTYPE"/>
	   </xsl:variable>

	   <xsl:variable name ="NonDisplayToneTagging">
		   <xsl:value-of select="($DisplayType ='None') and ($ToneTaggingEnable = 'true')"/>
	   </xsl:variable>
	   <!-- End added -->
	   
	   <xsl:if test="not($NonDisplayToneTagging = 'true')">
		   <tr>
			   <td class = "em">
				   <xsl:value-of select = "ENTRY_DATA/MDCC_MDCSYSINDEX/@DISPLAY_NAME" />
			   </td>
			   <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "MDCC_MDCSYSINDEX" />
		   </tr>
		   <tr>
			   <td class = "em">
				   <xsl:value-of select = "ENTRY_DATA/MDCC_RVTPERSINDEX/@DISPLAY_NAME" />
			   </td>
			   <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "MDCC_RVTPERSINDEX" />
		   </tr>
		   <tr>
			   <td class = "em">
				   <xsl:value-of select = "ENTRY_DATA/MDCC_STRIPPLDPLEN/@DISPLAY_NAME" />
			   </td>
			   <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "MDCC_STRIPPLDPLEN" />
		   </tr>
	   </xsl:if>
	   <!-- End updated -->
	   
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/MDCC_MDCCALLID/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "MDCC_MDCCALLID" />
         </tr>
         
         <!-- Added by Alice Wan, CCB410 -->
         <xsl:if test = "($ToneTaggingEnable = 'true')"> 
           <tr>
              <td class = "em">
                 <xsl:value-of select = "ENTRY_DATA/MDCC_MDCCALLALERTTONETAG/@DISPLAY_NAME" />
              </td>
              <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "MDCC_MDCCALLALERTTONETAG" />
           </tr>
        </xsl:if>
        
        <xsl:if test = "($ToneTaggingEnable = 'true')"> 
           <tr>
              <td class = "em">
                 <xsl:value-of select = "ENTRY_DATA/MDCC_MDCSELCALLTONETAG/@DISPLAY_NAME" />
              </td>
              <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "MDCC_MDCSELCALLTONETAG" />
           </tr>
        </xsl:if>
        <!-- Added by Alice Wan, CCB410 -->
         
         <xsl:text disable-output-escaping = "yes">
            &lt;table>
         </xsl:text>
         <br />         
   </xsl:template>
   
   <xsl:template match = "ENTRY_DATA" mode = "MDCC_MDCSYSINDEX">
      <td>
         <xsl:variable name = "index">
            <xsl:value-of select = "MDCC_MDCSYSINDEX" />
         </xsl:variable>
         <xsl:apply-templates select = "../../MDC_BLOCK/ENTRY_DATA[position() = ($index + 1)]/ALIAS" />
      </td>
   </xsl:template>
   
   <xsl:template match = "ENTRY_DATA" mode = "MDCC_RVTPERSINDEX">
      <td>
         <xsl:variable name = "index">
            <xsl:value-of select = "MDCC_RVTPERSINDEX" />
         </xsl:variable>
         
         <xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR = '1'">
         	<xsl:choose>
            	<xsl:when test = "$index = '255'">
               		Selected
            	</xsl:when>
            	<xsl:when test = "MDCC_RVTPERSTYPE = 'LS Trunking'">
               		<!--LTR <xsl:apply-templates select = "../../LG_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS"/>-->
               		LTR <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA[position() = ($index+1)]/ALIAS"/>
            	</xsl:when>
            	<xsl:otherwise>
              		CNV <xsl:apply-templates select = "../../CP_BLOCK/ENTRY_DATA[position() = ($index + 1)]/ALIAS" />
            	</xsl:otherwise>
         	</xsl:choose>
         </xsl:if>
         
         <xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR = '0'">
         	<xsl:choose>
            	<xsl:when test = "$index = '255'">
               		Selected
            	</xsl:when>
            	<xsl:otherwise>
              		<xsl:apply-templates select = "../../CP_BLOCK/ENTRY_DATA[position() = ($index + 1)]/ALIAS" />
            	</xsl:otherwise>
         	</xsl:choose>
         </xsl:if>

      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "MDCC_STRIPPLDPLEN">
      <td>
         <xsl:value-of select = "MDCC_STRIPPLDPLEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "MDCC_MDCCALLID">
      <td>
         <xsl:value-of select = "MDCC_MDCCALLID" />
      </td>
   </xsl:template>
   <!--CDDts06746-end-->
   
   <!-- Added by Alice Wan, CCB410 -->
   <xsl:template match="ENTRY_DATA" mode = "MDCC_MDCCALLALERTTONETAG">
     <td>
	    <xsl:value-of select = "MDCC_MDCCALLALERTTONETAG" />
     </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "MDCC_MDCSELCALLTONETAG">
     <td>
	    <xsl:value-of select = "MDCC_MDCSELCALLTONETAG" />
     </td>
   </xsl:template>
   <!-- Added by Alice Wan, CCB410 -->
   

   <xsl:template match = "MENU_BLOCK">
      <h3>^0421^</h3>
      <table class = "nonrepeat">
         <tr>
            <td class = "left">
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_MENUTOT/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_MENUTOT"/>
            </td>
         </tr>         
         <tr>
            <td class = "left">
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_RECALLLASTSEL/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_RECALLLASTSEL"/>
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_SYSSCANTOPLEVMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_SYSSCANTOPLEVMOPT"/>
            </td>
         </tr>
        <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani'))">
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_RPTRTATOPLEVMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_RPTRTATOPLEVMOPT"/>
            </td>
         </tr>
        </xsl:if>
            <!-- Not visible in EMEA radios -->
			<xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA') ) and 
			                not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'Japan') )">
			<tr>
               <td class = "left">
                  <xsl:value-of select = "ENTRY_DATA/MN_EDITCUSTOMPLSUBMOPT/@DISPLAY_NAME"/>:
               </td>
               <td>
                  <xsl:value-of select = "ENTRY_DATA/MN_EDITMODETOPLEVMOPT"/>
               </td>
            </tr>
			</xsl:if>
			
         <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani')) and
                         ( contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                           contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                           contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') )">
	         <tr>
	            <td class = "left">
	               <xsl:value-of select = "ENTRY_DATA/MN_PHNTOPLEVMOPT/@DISPLAY_NAME"/>:
	            </td>
	            <td>
	               <xsl:value-of select = "ENTRY_DATA/MN_PHNTOPLEVMOPT"/>
	            </td>
	         </tr>
         </xsl:if>
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_SCANLSTSUBMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_SCANLSTSUBMOPT"/>
            </td>
         </tr>
         <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani')) and
                         ( contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                           contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') )">
            <tr>
               <td class = "left">
                  <xsl:value-of select = "ENTRY_DATA/MN_PHNLSTSUBMOPT/@DISPLAY_NAME"/>:
               </td>
               <td>
                  <xsl:value-of select = "ENTRY_DATA/MN_PHNLSTSUBMOPT"/>
               </td>
            </tr>
         </xsl:if>
        <xsl:if test = "not( contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani') and
                             contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') )">
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_SELCALSUBMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_SELCALSUBMOPT"/>
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_CALLALERTSUBMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_CALLALERTSUBMOPT"/>
            </td>
         </tr>
         </xsl:if>
	 <xsl:if test ="contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'Japan') and
	 		contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
	         <tr>
	            <td class = "left">
	               <xsl:value-of select = "ENTRY_DATA/MN_RADCHKSUBMOPT/@DISPLAY_NAME"/>:
	            </td>
	            <td>
	               <xsl:value-of select = "ENTRY_DATA/MN_RADCHKSUBMOPT"/>
	            </td>
	         </tr>
	 </xsl:if>
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_SQUELCHSUBMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_SQUELCHSUBMOPT"/>
            </td>
         </tr>         
            <tr>
               <td class = "left">
                  <xsl:value-of select = "ENTRY_DATA/MN_SELPWRLEVSUBMOPT/@DISPLAY_NAME"/>:
               </td>
               <td>
                  <xsl:value-of select = "ENTRY_DATA/MN_SELPWRLEVSUBMOPT"/>
               </td>
            </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_OPTBOARDSUBMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_OPTBOARDSUBMOPT"/>
            </td>
         </tr>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
            <tr>
               <td class = "left">
                  ^0444^:
               </td>
               <td>
                  <xsl:value-of select = "ENTRY_DATA/MN_LIGHTDISSUBMOPT"/>
               </td>
            </tr>
         </xsl:if>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK')">         
            <tr>
               <td class = "left">
                  <xsl:value-of select = "ENTRY_DATA/MN_LIGHTDISSUBMOPT/@DISPLAY_NAME"/>:
               </td>
               <td>
                  <xsl:value-of select = "ENTRY_DATA/MN_LIGHTDISSUBMOPT"/>
               </td>
            </tr>
         </xsl:if>
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_SWVERSUBMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_SWVERSUBMOPT"/>
            </td>
         </tr>
         <!-- Added by Alice Wan, CCB410 -->			
	 <xsl:if test ="$RadioLockEnable = 'true'">
           <tr>
              <td class = "left">
                 <xsl:value-of select = "ENTRY_DATA/MN_RADLOCKSUBMOPT/@DISPLAY_NAME"/>:
              </td>
              <td>
                 <xsl:value-of select = "ENTRY_DATA/MN_RADLOCKSUBMOPT"/>
              </td>
           </tr>
	</xsl:if>	
	<!-- Added by Alice Wan, CCB410 -->
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_TONEDISASUBMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_TONEDISASUBMOPT"/>
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_KEYPADTONESSUBMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_KEYPADTONESSUBMOPT"/>
            </td>
         </tr>
         <tr>
            <td class = "left">
               <xsl:value-of select = "ENTRY_DATA/MN_CALLTONETAGSUBMOPT/@DISPLAY_NAME"/>:
            </td>
            <td>
               <xsl:value-of select = "ENTRY_DATA/MN_CALLTONETAGSUBMOPT"/>
            </td>
         </tr>          
            <tr>
               <td class = "left">
                  <xsl:value-of select = "ENTRY_DATA/MN_ESCALERTSUBMOPT/@DISPLAY_NAME"/>:
               </td>
               <td>
                  <xsl:value-of select = "ENTRY_DATA/MN_ESCALERTSUBMOPT"/>
               </td>
            </tr>

		  <!-- Added by Xiao Yuek, CCB393 -->
		  <xsl:variable name = "cpver">
			  <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
		  </xsl:variable>
		  
		  <xsl:variable name = "MDFRussianFlag">
			  <xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RUSSIAN_EN"/>
		  </xsl:variable>
		  
		  <xsl:variable name ="RegionID">
			  <xsl:value-of select="/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID"/>
		  </xsl:variable>		 
			  		  
		  <xsl:variable name ="RussianEnable">
			  <xsl:value-of select="($cpver >= '08.00') and ($RegionID = 'EMEA') and ($MDFRussianFlag = '1')"/>
		  </xsl:variable>

		  <xsl:if test="$RussianEnable = 'true'">
			  <td class = "left">
				  <xsl:value-of select = "ENTRY_DATA/MN_LANGMODESUBMOPT/@DISPLAY_NAME"/>:
			  </td>
			  <td>
				  <xsl:value-of select = "ENTRY_DATA/MN_LANGMODESUBMOPT"/>
			  </td>
		  </xsl:if>
      </table>
   </xsl:template>

   <xsl:template match = "ELP_ELM_CODEPLUG" mode = "option_board">
      <table class = "nonrepeat">
         <tr>
            <td class = "left">
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_OPTBRDTYPE/@DISPLAY_NAME" />:
            </td>
            <td>
               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_OPTBRDTYPE" />
            </td>
         </tr>     
        <!-- Added by Alice Wan, CCB410 2010-7-20 -->
           <xsl:if test = "($VoiceScramblingEnable = 'true')"> 
               <tr>
	            <td class = "left">
	               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_VOISCRAMBCODE/@DISPLAY_NAME" />:
	            </td>
	            <td>
				     <xsl:choose>
				        <!-- When not Voice Scrambling Option Interface, N/A -->
                        <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_OPTBRDTYPE, '^3268^') ">
						   <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_VOISCRAMBCODE" />
						</xsl:when>
                        <xsl:otherwise>
                           ^0316^
                        </xsl:otherwise>
		             </xsl:choose>	               
	            </td>
               </tr>
          </xsl:if>
	<!-- Added by Alice Wan, CCB410 2010-7-20 -->
               <tr>
                  <td class = "left">
                     <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_OPTBRDCONFIGEN/@DISPLAY_NAME"/>:
                  </td>
                  <td>
         	     <xsl:choose>
				        <!-- When Simple Decoder or None, N/A -->
                        <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_OPTBRDTYPE, '^0631^') or
						                  contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_OPTBRDTYPE, '^0602^') ">
						   ^0316^
						</xsl:when>
						<!-- When not imported, N/A -->
						<xsl:when test = "RRW/OBC_BLOCK/LIST_INFO/LIST_QUANTITY = '0'">
                     	   ^0316^
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_OPTBRDCONFIGEN" />
                        </xsl:otherwise>
		     </xsl:choose>
                  </td>
               </tr>
           <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_SDT, '1')">
               <tr>
	            <td class = "left">
	               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_OBDATADOWNEN/@DISPLAY_NAME" />:
	            </td>
	            <td>
	               <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_OBDATADOWNEN" />
	            </td>
               </tr>
          </xsl:if>
      </table>
   </xsl:template>

     
   <xsl:template match="ENTRY_DATA" mode = "CP_TXADMITCRITERIA">
	  <td>
	     <xsl:value-of select="CP_TXADMITCRITERIA" /> 
	  </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "X_DTMF_CALLTYPE">
      <td>
	  <xsl:value-of select="X_DTMF_CALLTYPE" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "X_DTMF_CALLLED">
      <td>
	  <xsl:value-of select="X_DTMF_CALLLED" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "DTMF_ALERTAUTORESEN">
      <td>
	  <xsl:value-of select="DTMF_ALERTAUTORESEN" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "DTMF_AUTORESTIMERTYPE">
      <td>
	  <xsl:value-of select="DTMF_AUTORESTIMERTYPE" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "DTMF_ACKTYPE">
     <td>
	    <xsl:value-of select = "DTMF_ACKTYPE" />
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "DTMF_PRIMARYID">
      <td>
	  <xsl:value-of select="DTMF_PRIMARYID" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "DTMF_GRPID">
      <td>
	  <xsl:value-of select="DTMF_GRPID" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "DTMF_PTTIDTYPE">
      <td>
	  <xsl:value-of select="DTMF_PTTIDTYPE" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "X_DTMF_PTTSIDETONE">
      <td>
	  <xsl:value-of select="X_DTMF_PTTSIDETONE" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "DTMF_PRETIME">
      <td>
	  <xsl:value-of select="DTMF_PRETIME" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "DTMF_RESETDUR">
      <td>
	  <xsl:value-of select="DTMF_RESETDUR" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "DTMF_TXTONEDUR">
      <td>
	  <xsl:value-of select="DTMF_TXTONEDUR" /> 
	  </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "DTMF_TXTONEINTERVAL">
      <td>
	  <xsl:value-of select="DTMF_TXTONEINTERVAL" /> 
	  </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "QC_PRETIME">
      <td>
	  <xsl:value-of select="QC_PRETIME" /> 
	  </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "QC_LONGTONEDUR">
      <td>
	  <xsl:value-of select="QC_LONGTONEDUR" /> 
	  </td>
   </xsl:template>

   <xsl:template name="aliastransform">
      <xsl:param name="aliasname1"></xsl:param>
         <xsl:variable name = "x1">
            <xsl:value-of select="translate($aliasname1, '(', '&amp;')"/>      
         </xsl:variable>
         <xsl:value-of select = "translate($x1, ')?!$%', 'nbsp;')" />
   </xsl:template>   
   
   
   <xsl:template match = 'LIST_DATA' mode = "LS_BLOCK">
       <xsl:choose>
          <xsl:when test = "position() = '1'">
            <h3>       
               <xsl:apply-templates select = 'ENTRY_INFO/ALIAS' />
            </h3>
          </xsl:when>
          <xsl:otherwise>
            <h3 class = "breakBefore">       
               <xsl:apply-templates  select = 'ENTRY_INFO/ALIAS' />
            </h3>
          </xsl:otherwise>
       </xsl:choose>
       <table>
         <tr>
           <td class = "em">
             <xsl:value-of select="ENTRY_INFO/LS_AREAIDBIT/@DISPLAY_NAME" />
           </td>
           <td>
               <xsl:value-of select = 'ENTRY_INFO/LS_AREAIDBIT' />
           </td>
         </tr>
         <tr>
           <td class = "em">
             <xsl:value-of select="ENTRY_INFO/LS_FRONTPORCH/@DISPLAY_NAME" />
           </td>
           <td>
               <xsl:value-of select = 'ENTRY_INFO/LS_FRONTPORCH' />
           </td>
         <tr>
         </tr>
           <td class = "em">
             <xsl:value-of select="ENTRY_INFO/LS_DISCONNECTWORD/@DISPLAY_NAME" />
           </td>
           <td>
               <xsl:value-of select = 'ENTRY_INFO/LS_DISCONNECTWORD' />
           </td>
         <tr>
         </tr>
           <td class = "em1">
              ^0809^
           </td>
         <tr>
         </tr>
           <td class = "em">
             <xsl:value-of select="ENTRY_INFO/LS_DATADEVIATION125/@DISPLAY_NAME" />
           </td>
           <td>
               <xsl:value-of select = 'ENTRY_INFO/LS_DATADEVIATION125' />
           </td>
         <tr>
         </tr>
           <td class = "em">
             <xsl:value-of select="ENTRY_INFO/LS_DATADEVIATION2025/@DISPLAY_NAME" />
           </td>
           <td>
              <!-- CCB364-Alice -->
              <xsl:choose>
	       		<xsl:when test ="contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KDC4AA2') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KDC4AA2AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50RDC4AA2') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50RDC4AA2AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65KDC4AA2') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65KDC4AA2AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65RDC4AA2') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65RDC4AA2AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65KDF4AA3') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65KDF4AA3AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65RDF4AA3') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65RDF4AA3AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65KDH4AA4') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65KDH4AA4AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65RDH4AA4') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H65RDH4AA4AN') or
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'M50KNF4AA2') or		       				     
	       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'M50KNF4AA2AN')" >
	       				     ^0316^
	       		</xsl:when>
	       		<xsl:otherwise>
                            <xsl:value-of select = 'ENTRY_INFO/LS_DATADEVIATION2025' />
                        </xsl:otherwise>
	       </xsl:choose>
               <!-- CCB364-Alice -->
           </td>
         <tr>
         </tr>
           <td class = "em1">
              ^0810^
           </td>
         <tr>
         </tr>
           <td class = "em">
             <xsl:value-of select="ENTRY_INFO/LS_INVERTRXDATA/@DISPLAY_NAME" />
           </td>
           <td>
               <xsl:value-of select = 'ENTRY_INFO/LS_INVERTRXDATA' />
           </td>
         <tr>
         </tr>
           <td class = "em">
             <xsl:value-of select="ENTRY_INFO/LS_INVERTTXDATA/@DISPLAY_NAME" />
           </td>
           <td>
               <xsl:value-of select = 'ENTRY_INFO/LS_INVERTTXDATA' />
           </td>
         </tr>        
       </table>     
         
         <xsl:variable name = "site_index" select = "position()"/>
           
<!-- Repeaters -->  
       <table>     
         <xsl:variable name = "repeater_number" select = "count(./ENTRY_DATA)" />
         <xsl:call-template name = 'lrf_loop' >
             <xsl:with-param name = "cycle" select = 'ceiling( $repeater_number div 8)' />
             <xsl:with-param name = "times" select = '1' />
         </xsl:call-template>       
       </table>     
<!-- Groups -->    
         <xsl:variable name = "site_index" select = "position()"/>
         <xsl:variable name = "group_before" select = "sum(../LIST_DATA[position() &lt; $site_index]/X_LS_GROUPNUMBER)" /> 
         <xsl:apply-templates select = '/ELP_ELM_CODEPLUG/RRW/LG_BLOCK'>
             <xsl:with-param name = "sitegroup_first" select = '$group_before + 1' />
             <xsl:with-param name = "sitegroup_last" select = '$group_before + X_LS_GROUPNUMBER' />
         </xsl:apply-templates> 
<!-- Universal ID -->
       <table>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LUID_BLOCK/LIST_DATA[position() = $site_index]" mode = "LUID_BLOCK"/>
       </table>
   </xsl:template>
    
<!-- Repeaters -->
   <xsl:template name = 'lrf_loop'>
       <xsl:param name = 'cycle' />   
       <xsl:param name = 'times' />   
       <xsl:if test = "$cycle &gt;= $times" >
           <xsl:call-template name = "LRF_TABLE">
               <xsl:with-param name = "startIndex" select = '$times * 8 - 7' />
               <xsl:with-param name = "endIndex" select = '8 * $times'/>
           </xsl:call-template>
           <xsl:call-template name = 'lrf_loop'> 
               <xsl:with-param name = "cycle" select = '$cycle' />
               <xsl:with-param name = 'times' select = '$times + 1' />
           </xsl:call-template>
       </xsl:if>  
   </xsl:template>
      
   <xsl:template name = "LRF_TABLE">
      <xsl:param name = "startIndex">1</xsl:param>
      <xsl:param name = "endIndex">8</xsl:param>      
      <tr><td class = "em2">^0811^</td></tr>
      <tr>
         <xsl:text disable-output-escaping = "yes">
            &lt;th width = "25%"> &amp;nbsp &lt;/th>
         </xsl:text>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LRF_ALIAS" /> 
      </tr >
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/X_LRF_REPEATERNUMBER/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_LRF_REPEATERNUMBER"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LRF_REPINTERCONNECTFLAG/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LRF_REPINTERCONNECTFLAG"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LRF_CHANBANDWIDTHSEL/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LRF_CHANBANDWIDTHSEL"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LRF_COMPANDINGSTATE/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LRF_COMPANDINGSTATE"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LRF_EMPHASISSEL/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LRF_EMPHASISSEL"/>  
      </tr>
      <tr>
        <td class = "em1">
           ^0805^
        </td>
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LRF_RXFREQ/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LRF_RXFREQ"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LRF_RXREFFREQ/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LRF_RXREFFREQ"/>  
      </tr>
      <tr>
        <td class = "em1">
           ^0806^
        </td>
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LRF_TXFREQ/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LRF_TXFREQ"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LRF_TXREFFREQ/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LRF_TXREFFREQ"/>  
      </tr>       
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "LRF_ALIAS">
      <th>
         <xsl:apply-templates select = "ALIAS" />
      </th>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "X_LRF_REPEATERNUMBER">
      <td>
         <xsl:value-of select = 'X_LRF_REPEATERNUMBER' />
      </td>
   </xsl:template>  
   <xsl:template match="ENTRY_DATA" mode = "LRF_REPINTERCONNECTFLAG">
      <td>
         <xsl:value-of select = 'LRF_REPINTERCONNECTFLAG' />
      </td>
   </xsl:template>  
   <xsl:template match="ENTRY_DATA" mode = "LRF_CHANBANDWIDTHSEL">
      <td>
         <xsl:value-of select = 'LRF_CHANBANDWIDTHSEL' />
      </td>
   </xsl:template>     
   <xsl:template match="ENTRY_DATA" mode = "LRF_COMPANDINGSTATE">
      <td>
         <xsl:value-of select = 'LRF_COMPANDINGSTATE' />
      </td>
   </xsl:template> 
   <xsl:template match="ENTRY_DATA" mode = "LRF_EMPHASISSEL">
      <td>
         <xsl:value-of select = 'LRF_EMPHASISSEL' />
      </td>
   </xsl:template>  
   <xsl:template match="ENTRY_DATA" mode = "LRF_RXFREQ">
      <td>
         <xsl:value-of select = 'LRF_RXFREQ' />
      </td>
   </xsl:template>  
   <xsl:template match="ENTRY_DATA" mode = "LRF_RXREFFREQ">
      <td>
         <xsl:value-of select = 'LRF_RXREFFREQ' />
      </td>
   </xsl:template>  
   <xsl:template match="ENTRY_DATA" mode = "LRF_TXFREQ">
      <td>
         <xsl:value-of select = 'LRF_TXFREQ' />
      </td>
   </xsl:template>  
   <xsl:template match="ENTRY_DATA" mode = "LRF_TXREFFREQ">
      <td>
         <xsl:value-of select = 'LRF_TXREFFREQ' />
      </td>
   </xsl:template>  
   
   
   <xsl:template match="LG_BLOCK">   
       <xsl:param name = 'sitegroup_first'/>
       <xsl:param name = 'sitegroup_last'/> 
       <xsl:call-template name = 'lg_loop' >
           <xsl:with-param name = "group_first" select = '$sitegroup_first' />
           <xsl:with-param name = "group_last" select = '$sitegroup_last' />
       </xsl:call-template>
   </xsl:template>   
     
   <xsl:template name = 'lg_loop'>
       <xsl:param name = 'group_first'/>
       <xsl:param name = 'group_last'/>    
       <xsl:if test = "$group_first &lt;= $group_last" >
           <xsl:choose>
               <xsl:when test = "$group_first+8 &gt; $group_last">
                   <xsl:call-template name = "LG_TABLE">
                       <xsl:with-param name = "startIndex" select = '$group_first' />
                       <xsl:with-param name = "endIndex" select = '$group_last'/> 
                   </xsl:call-template>  
               </xsl:when>
               <xsl:otherwise>
                   <xsl:call-template name = "LG_TABLE">
                       <xsl:with-param name = "startIndex" select = '$group_first' />
                       <xsl:with-param name = "endIndex" select = '$group_first + 7'/> 
                   </xsl:call-template>  
                   <xsl:call-template name = 'lg_loop'> 
                       <xsl:with-param name = "group_first" select = '$group_first+8' />
                       <xsl:with-param name = 'group_last' select = '$group_last' />
                   </xsl:call-template>
               </xsl:otherwise>  
           </xsl:choose>          
       </xsl:if>     
   </xsl:template>
   
   
   <xsl:template name = "LG_TABLE">
      <xsl:param name = "startIndex"/>
      <xsl:param name = "endIndex"/>    
      <table> 
      <tr><td class = "em2">^0802^</td></tr>
      <tr>
         <xsl:text disable-output-escaping = "yes">
            &lt;th width = "25%"> &amp;nbsp &lt;/th>
         </xsl:text>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_ALIAS" /> 
      </tr >
      
      <tr> 
         <td class = "em">
          ^0803^
          </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_LG_CHNNELPOSITION"/> 
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_HOMERPTFREQINDEX/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_HOMERPTFREQINDEX"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_SCANLISTINDEX/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_SCANLISTINDEX"/>  
      </tr>
      <tr>
         <td class = "em">
            <xsl:value-of select="ENTRY_DATA/LG_AUTOSCANEN/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_AUTOSCANEN"/>         
      </tr>
      <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') ">
         <tr> 
            <td class = "em">
              <xsl:value-of select="ENTRY_DATA/LG_PHSYSINDEX/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_PHSYSINDEX"/>  
         </tr>
      </xsl:if>
      <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
         <tr> 
            <td class = "em">
              <xsl:value-of select="ENTRY_DATA/LG_DATAREVERTPERSINDEX/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_DATAREVERTPERSINDEX"/>  
         </tr>
      </xsl:if>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_OPTBRDFEATEN/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_OPTBRDFEATEN"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_OPTBRDCONFIGINDEX/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_OPTBRDCONFIGINDEX"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_CALLLIGHT/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_CALLLIGHT"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_DATAONLY/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_DATAONLY"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_INTERCONNECTEN/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_INTERCONNECTEN"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_TALKPERTONEEN/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TALKPERTONEEN"/>   
      </tr>
      <!-- TridentData-Alice -->
      <xsl:variable name = "cpver">
         <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
      </xsl:variable>     	
      <xsl:if test= "$cpver >= '06.00' "> 
         <xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_DATAOPERTRIDENT = '1'"> 
            <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">                                                                           	
               <tr> 
                  <td class = "em">
                     <xsl:value-of select="ENTRY_DATA/LG_DATAOPERTRIDENTEN/@DISPLAY_NAME" />
                  </td>
                  <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_DATAOPERTRIDENTEN"/>   
               </tr>
            </xsl:if> 
         </xsl:if>
      </xsl:if>
      <!-- TridentData-Alice -->
      
      <!-- Rx Parameters -->
      <tr>
         <td class = "em1">
            ^0805^
         </td>
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_RXLOWID/@DISPLAY_NAME" />
         </td>  
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_RXID"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_RXSIGINDEX/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_RXSIGINDEX"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_UNMUTETYPE/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_UNMUTETYPE"/>   
      </tr>
      
      <!-- Tx Parameters -->
      <tr>
         <td class = "em1">
            ^0806^
         </td>
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_TXID/@DISPLAY_NAME" />
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TXID"/>   
         </td>
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_TXINHIBITLOWID/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TXINHIBITID"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_TXSIGINDEX/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TXSIGINDEX"/>  
      </tr>
      <tr> 
         <td class  = "em">
          <xsl:value-of select="ENTRY_DATA/LG_TXPWRLEVSEL/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TXPWRLEVSEL"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LG_TOT/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TOT"/>   
      </tr>
     </table>               
   </xsl:template >   
   
   <xsl:template match="ENTRY_DATA" mode = "LG_ALIAS">
      <th>
         <xsl:apply-templates select = "ALIAS" />
      </th>
   </xsl:template>
 
   
   <xsl:template match="ENTRY_DATA" mode = "LG_AUTOSCANEN">
      <td>
         <xsl:value-of select = 'LG_AUTOSCANEN' />
      </td>
   </xsl:template>   
   
   
   <xsl:template match="ENTRY_DATA" mode = "LG_OPTBRDFEATEN">
      <td>
         <xsl:value-of select = 'LG_OPTBRDFEATEN' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_CALLLIGHT">
      <td>
         <xsl:value-of select = 'LG_CALLLIGHT' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_DATAONLY">
      <td>
         <xsl:value-of select = 'LG_DATAONLY' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_INTERCONNECTEN">
      <td>
         <xsl:value-of select = 'LG_INTERCONNECTEN' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_TALKPERTONEEN">
      <td>
         <xsl:value-of select = 'LG_TALKPERTONEEN' />
      </td>
   </xsl:template> 
   
   <xsl:template match="ENTRY_DATA" mode = "LG_UNMUTETYPE">
      <td>
         <xsl:value-of select = 'LG_UNMUTETYPE' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_TXID">
      <td>
         <xsl:value-of select = 'LG_TXID' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_TXPWRLEVSEL">
      <td>
         <xsl:value-of select = 'LG_TXPWRLEVSEL' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_TOT">
      <td>
         <xsl:value-of select = 'LG_TOT' />
      </td>
   </xsl:template>  
   
    <xsl:template match="ENTRY_DATA" mode = "X_LG_CHNNELPOSITION">
      <td>
        <xsl:call-template name = "X_LG_CHNNELPOSITION">
          <xsl:with-param name = 'alias' select = 'ALIAS'/>
          <xsl:with-param name = 'site_index' select = 'LG_LTRSYSINDEX'/>
        </xsl:call-template>
      </td>
   </xsl:template>   
   
   <xsl:template name="X_LG_CHNNELPOSITION">
       <xsl:param name = 'alias'/>
       <xsl:param name = 'site_index'/>      
       <xsl:for-each select = '/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA'>
           <xsl:if test = "ALIAS=$alias and LG_LTRSYSINDEX=$site_index">
               <xsl:variable name = 'index' select = 'position()-1' />
               <xsl:variable name = 'type'>LS Trunking</xsl:variable>
               <xsl:apply-templates select = '/ELP_ELM_CODEPLUG/RRW/PA_BLOCK/LIST_DATA/ENTRY_DATA[PA_PERSTYPE = $type and PA_PERSINDEX = $index]' mode = 'channel_position'/>
           </xsl:if>
       </xsl:for-each>
   </xsl:template>   
   
   <xsl:template match = "ENTRY_DATA" mode = 'channel_position'>
             <xsl:value-of select = 'count(preceding-sibling::*)'/>
   </xsl:template>     
   
  <!-- TridentData-Alice --> 
   <xsl:template match="ENTRY_DATA" mode = "LG_DATAOPERTRIDENTEN">
      <td>
         <xsl:value-of select = 'X_LG_DATAOPERTRIDENTEN' />
      </td>
   </xsl:template>        
   <!-- TridentData-Alice -->          
   
   <xsl:template match="ENTRY_DATA" mode = "LG_HOMERPTFREQINDEX">
      <xsl:variable name = "siteindex">
          <xsl:value-of select = "LG_LTRSYSINDEX" />
      </xsl:variable>
      <xsl:variable name = "repeaterindex">
          <xsl:value-of select = "LG_HOMERPTFREQINDEX" />
      </xsl:variable>     
      <td>
          <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LS_BLOCK/LIST_DATA[position() = ($siteindex +1)]/ENTRY_DATA[X_LRF_REPEATERNUMBER = ($repeaterindex +1)]/ALIAS" />      
      </td>             
   </xsl:template>    
   
   <!-- TridentData-Alice -->
   <xsl:template match="ENTRY_DATA" mode = "LG_SCANLISTINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_SCANLISTINDEX" />
      </xsl:variable>
      <td>
         <xsl:choose>
            <xsl:when test = "LG_DATAOPERTRIDENTEN = '1'">
               ^0316^
            </xsl:when>
            <xsl:when test = "$index = '255'">
               ^0327^
            </xsl:when>
            <xsl:when test = "$index != '255'"> 
               <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/SLI_BLOCK/LIST_DATA[position() = ($index +1)]/ENTRY_INFO/ALIAS" />
            </xsl:when>
         </xsl:choose>
      </td>
   </xsl:template> 
   <!-- TridentData-Alice -->  
   
   <!-- TridentData-Alice -->
   <xsl:template match="ENTRY_DATA" mode = "LG_RXSIGINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_RXSIGINDEX" />
      </xsl:variable>
      <td>
        <xsl:choose>
            <xsl:when test = "LG_DATAOPERTRIDENTEN = '1'">
               ^0316^
            </xsl:when>
            <xsl:when test = "$index = '255' or LG_RXSIGTYPE = 'None'">
               ^0327^
            </xsl:when>
            <xsl:when test = "$index != '255'"> 
               <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/MDC_BLOCK /ENTRY_DATA[position() = ($index +1)]/ALIAS" />
            </xsl:when> 
         </xsl:choose> 
      </td>     
   </xsl:template>  
   <!-- TridentData-Alice -->
   
   <!-- TridentData-Alice -->
   <xsl:template match="ENTRY_DATA" mode = "LG_TXSIGINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_TXSIGINDEX" />
      </xsl:variable>
      <td>
         <xsl:choose>
            <xsl:when test = "LG_DATAOPERTRIDENTEN = '1'">
               ^0316^
            </xsl:when>
            <xsl:when test = "$index = '255' or LG_TXSIGTYPE = 'None'">
               ^0327^
            </xsl:when>
            <xsl:when test = "$index != '255'"> 
               <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/MDC_BLOCK /ENTRY_DATA[position() = ($index +1)]/ALIAS" />
            </xsl:when>
         </xsl:choose>
      </td>
   </xsl:template>  
   <!-- TridentData-Alice -->
      
   <xsl:template match="ENTRY_DATA" mode = "LG_PHSYSINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_PHSYSINDEX" />
      </xsl:variable>
      <td>
         <xsl:choose>
            <xsl:when test = "$index = '255'">
               ^0327^
            </xsl:when>
            <xsl:when test = "$index != '255'"> 
               <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/PS_BLOCK/ENTRY_DATA[position() = ($index +1)]/ALIAS" />
            </xsl:when>
         </xsl:choose>
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_DATAREVERTPERSINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_DATAREVERTPERSINDEX" />
      </xsl:variable>
      <xsl:variable name = "con_type">Conventional</xsl:variable>
      <xsl:variable name = "lty_type">LS Trunking</xsl:variable>
      <xsl:choose>
          <xsl:when test = "$con_type = LG_DATAREVERTPERSTYPE">
              <td>CNV <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
          </xsl:when>
          <xsl:when test = "$lty_type = LG_DATAREVERTPERSTYPE">
              <td>LTR <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
          </xsl:when>
      </xsl:choose>
   </xsl:template>    
   <xsl:template match="ENTRY_DATA" mode = "LG_OPTBRDCONFIGINDEX">
      <td>
          <xsl:value-of select = "LG_OPTBRDCONFIGINDEX" />
      </td>
   </xsl:template>   
      
   <xsl:template match="ENTRY_DATA" mode = "LG_RXID">
      <td>
         <xsl:choose>
            <xsl:when test = "LG_RXLOWID = '255'">
               ^0327^
            </xsl:when>
            <xsl:when test = "LG_RXHIGHID = '255'">
               ^0327^
            </xsl:when>
            <xsl:otherwise> 
                <xsl:value-of select = "LG_RXLOWID" />-<xsl:value-of select = "LG_RXHIGHID" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template> 
   
   <xsl:template match="ENTRY_DATA" mode = "LG_TXINHIBITID">
      <td>
         <xsl:choose>
            <xsl:when test = "LG_TXINHIBITLOWID = '255'">
               ^0327^
            </xsl:when>
            <xsl:when test = "LG_TXINHIBITHIGHID = '255'">
               ^0327^
            </xsl:when>
            <xsl:otherwise> 
                <xsl:value-of select = "LG_TXINHIBITLOWID" />-<xsl:value-of select = "LG_TXINHIBITHIGHID" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>    
   
   <xsl:template match = 'LIST_DATA' mode = "LUID_BLOCK" >  
      <xsl:if test = "ENTRY_DATA[1]">
          <tr><td class = "em2">^0812^</td></tr>
      </xsl:if>
      <tr>
         <xsl:text disable-output-escaping = "yes">
            &lt;th width = "25%"> &amp;nbsp &lt;/th>
         </xsl:text>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "LUID_ALIAS" /> 
      </tr >
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LUID_UNIVERRXID /@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "LUID_UNIVERRXID"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LUID_CALLLIGHT/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "LUID_CALLLIGHT"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="ENTRY_DATA/LUID_TXINHIBIT/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "ENTRY_DATA" mode = "LUID_TXINHIBIT"/>  
      </tr>
   </xsl:template>    
   
   <xsl:template match="ENTRY_DATA" mode = "LUID_ALIAS">
      <th>
         <xsl:apply-templates select = "ALIAS" />
      </th>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LUID_UNIVERRXID">
      <td>
         <xsl:value-of select = "LUID_UNIVERRXID" />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LUID_CALLLIGHT">
      <td>
         <xsl:value-of select = "LUID_CALLLIGHT" />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LUID_TXINHIBIT">
      <td>
         <xsl:value-of select = "LUID_TXINHIBIT" />
      </td>
   </xsl:template>   
      
   <xsl:template match = 'X_CHANNAL_ALIAS'>
       <tr>
           <td class = "em">
               <xsl:value-of select = 'position()'/>
           </td>
           <td>
               <xsl:variable name = "oldAlias">
                   <xsl:value-of select="." />
               </xsl:variable>
               <xsl:call-template name = "aliastransform">
                   <xsl:with-param name = "aliasname1">
                       <xsl:value-of select = "$oldAlias" />
                   </xsl:with-param>
               </xsl:call-template>
           </td>
       </tr>
   </xsl:template>
   
<!-- For ATIS & MOR -->

   <xsl:template match = "ATIS_BLOCK" >
         <tr>
            <xsl:text disable-output-escaping = "yes">
                  &lt;th> &amp;nbsp &lt;/th>
               </xsl:text>       
            <xsl:apply-templates select = "ENTRY_DATA" mode = "counting_atis" />   
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_USERCODE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_USERCODE" />
         </tr>
         <tr>
            <td class = "em">
               ^0901^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_DESTGRPID" />
         </tr>
         <tr>
            <td class = "em">
               ^0902^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_INITGRPID" />
         </tr>
         <tr>
            <td class = "em">
               ^0903^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_DESTINDIVIDUALID" />
         </tr>
         <tr>
            <td class = "em">
               ^0904^
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_INITINDIVIDUALID" />
         </tr>
         <tr>
           <td class = "em1">
              ^0905^
           </td>
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_KANIGRPCODEENEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_KANIGRPCODEENEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_PTTIDTYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_PTTIDTYPE" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_PTTBEHAVIOR/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_PTTBEHAVIOR" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_PTTSIDETONEEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_PTTSIDETONEEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_FLEETCALLEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_FLEETCALLEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_INTERGRPCALLEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_INTERGRPCALLEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_GRPUNMUTEEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_GRPUNMUTEEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_ACKPRETIME/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_ACKPRETIME" />
         </tr>         
        <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or  
                          contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')" >
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_FIXRETWAITTIME/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_FIXRETWAITTIME" />
         </tr>
        </xsl:if>
        
         <!-- Decode -->         
         <tr>
           <td class = "em1">
              ^0906^
           </td>
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_KANIGRPCODEDEEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_KANIGRPCODEDEEN" />
         </tr>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or 
                          contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')" >
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_CALLALERTTYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_CALLALERTTYPE" />
         </tr>
         </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_ATIS_CALLALERTLEDEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "X_ATIS_CALLALERTLEDEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/X_ATIS_SELCALLEDEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "X_ATIS_SELCALLEDEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_ALERTAUTORESEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_ALERTAUTORESEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_AUTORESTIMERTYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_AUTORESTIMERTYPE" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_COMPATIBLECALLEN/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_COMPATIBLECALLEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_DOSAUTOMUTEDUR/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_DOSAUTOMUTEDUR" />
         </tr>
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or  
                          contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')" >
          <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_DOSCOASTDUR/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_DOSCOASTDUR" />
          </tr>
          <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/ATIS_DOSCRITYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA" mode = "ATIS_DOSCRITYPE" />
          </tr>
         </xsl:if>
   </xsl:template>
   
   <xsl:template match = "ENTRY_DATA" mode = "counting_atis">
      <th>
	   <xsl:if test = "ALIAS != ''"> 
	      <xsl:apply-templates select = "ALIAS"/>
         </xsl:if>
	   <xsl:if test = "ALIAS = ''"> 
	      ^0328^
		<xsl:value-of select = "position()" />
	   </xsl:if>
      </th>
   </xsl:template>
   
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_USERCODE">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_USERCODE" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_DESTGRPID">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_DESTGRPID" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_INITGRPID">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_INITGRPID" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_DESTINDIVIDUALID">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_DESTINDIVIDUALID" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_INITINDIVIDUALID">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_INITINDIVIDUALID" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_KANIGRPCODEENEN">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_KANIGRPCODEENEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_PTTIDTYPE">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_PTTIDTYPE" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_PTTBEHAVIOR">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_PTTBEHAVIOR" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_PTTSIDETONEEN">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_PTTSIDETONEEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_FLEETCALLEN">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_FLEETCALLEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_INTERGRPCALLEN">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_INTERGRPCALLEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_GRPUNMUTEEN">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_GRPUNMUTEEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_ACKPRETIME">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_ACKPRETIME" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_FIXRETWAITTIME">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_FIXRETWAITTIME" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_KANIGRPCODEDEEN">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_KANIGRPCODEDEEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_CALLALERTTYPE">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_CALLALERTTYPE" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "X_ATIS_CALLALERTLEDEN">
      <td class = "repeat">
         <xsl:value-of select = "X_ATIS_CALLALERTLEDEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "X_ATIS_SELCALLEDEN">
      <td class = "repeat">
         <xsl:value-of select = "X_ATIS_SELCALLEDEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_ALERTAUTORESEN">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_ALERTAUTORESEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_AUTORESTIMERTYPE">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_AUTORESTIMERTYPE" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_COMPATIBLECALLEN">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_COMPATIBLECALLEN" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_DOSAUTOMUTEDUR">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_DOSAUTOMUTEDUR" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_DOSCOASTDUR">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_DOSCOASTDUR" />
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "ATIS_DOSCRITYPE">
      <td class = "repeat">
         <xsl:value-of select = "ATIS_DOSCRITYPE" />
      </td>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "CP_DATATRANSOB">
	<td>
	       <xsl:value-of select="CP_DATATRANSOB" />	
 	</td>
   </xsl:template>
   <xsl:template match = "SDT_BLOCK" >
         <tr>
            <xsl:text disable-output-escaping = "yes">
                  &lt;th> &amp;nbsp &lt;/th>
               </xsl:text>       
            <xsl:apply-templates select = "ENTRY_DATA" mode = "counting_sdt" />   
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/SDT_PRETIME/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA/SDT_PRETIME" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/SDT_DOSAUTOMUTEDUR/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA/SDT_DOSAUTOMUTEDUR"  />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/SDT_DOSCOASTDUR/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA/SDT_DOSCOASTDUR" />
         </tr>         
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/SDT_DOSCRITYPE/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA/SDT_DOSCRITYPE" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select = "ENTRY_DATA/SDT_FIXRETWAITTIME/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ENTRY_DATA/SDT_FIXRETWAITTIME" />
         </tr>                     
   </xsl:template>
   <xsl:template match = "SDT_PRETIME|SDT_DOSAUTOMUTEDUR|SDT_FIXRETWAITTIME">
      <td class = "repeat">
      	<xsl:value-of select = '.' />
      </td>
   </xsl:template>
   <xsl:template match = "SDT_DOSCOASTDUR|SDT_DOSCRITYPE">
      <td class = "repeat">
      	<xsl:choose>
      		<xsl:when test = "../SDT_DOSAUTOMUTEDUR = '0'">^0316^</xsl:when>
      		<xsl:otherwise>
      			<xsl:value-of select = '.' />
      		</xsl:otherwise>
      	</xsl:choose>
      </td>
   </xsl:template>
   <xsl:template match = "ENTRY_DATA" mode = "counting_sdt">
      <th>
	   <xsl:if test = "ALIAS != ''"> 
	      <xsl:apply-templates select = "ALIAS"/>
         </xsl:if>
	   <xsl:if test = "ALIAS = ''"> 
	      ^0328^
		<xsl:value-of select = "position()" />
	   </xsl:if>
      </th>
   </xsl:template>
   
   
</xsl:stylesheet>
         
